/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v25.message;

import ca.uhn.hl7v2.model.v25.group.*;
import ca.uhn.hl7v2.model.v25.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a TCU_U10 message structure (see chapter 13.3.10). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (Message Header) <b> </b></li>
                 * <li>2: SFT (Software Segment) <b>optional repeating</b></li>
                 * <li>3: EQU (Equipment Detail) <b> </b></li>
                 * <li>4: TCU_U10_TEST_CONFIGURATION (a Group object) <b> repeating</b></li>
                 * <li>5: ROL (Role) <b>optional </b></li>
 * </ul>
 */
public class TCU_U10 extends AbstractMessage  {

    /** 
     * Creates a new TCU_U10 message with custom ModelClassFactory.
     */
    public TCU_U10(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    /**
     * Creates a new TCU_U10 message with DefaultModelClassFactory. 
     */ 
    public TCU_U10() { 
       super(new DefaultModelClassFactory());
       init(new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(SFT.class, false, true);
                          this.add(EQU.class, true, false);
                          this.add(TCU_U10_TEST_CONFIGURATION.class, true, true);
                          this.add(ROL.class, false, false);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating TCU_U10 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.5"
     */
    public String getVersion() {
       return "2.5";
    }



    /**
     * Returns
     * MSH (Message Header) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * SFT (Software Segment) - creates it if necessary
     */
    public SFT getSFT() { 
       SFT ret = null;
       try {
          ret = (SFT)this.get("SFT");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * SFT (Software Segment) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SFT getSFT(int rep) { 
       SFT ret = null;
       try {
          ret = (SFT)this.get("SFT", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of SFT 
     */ 
    public int getSFTReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("SFT").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of SFT (Software Segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertSFT(SFT structure, int rep) throws HL7Exception { 
       super.insertRepetition( "SFT", structure, rep);
    }


    /**
     * Inserts a specific repetition of SFT (Software Segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public SFT insertSFT(int rep) throws HL7Exception { 
       return (SFT)super.insertRepetition("SFT", rep);
    }


    /**
     * Removes a specific repetition of SFT (Software Segment)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public SFT removeSFT(int rep) throws HL7Exception { 
       return (SFT)super.removeRepetition("SFT", rep);
    }



    /**
     * Returns
     * EQU (Equipment Detail) - creates it if necessary
     */
    public EQU getEQU() { 
       EQU ret = null;
       try {
          ret = (EQU)this.get("EQU");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * TEST_CONFIGURATION (a Group object) - creates it if necessary
     */
    public TCU_U10_TEST_CONFIGURATION getTEST_CONFIGURATION() { 
       TCU_U10_TEST_CONFIGURATION ret = null;
       try {
          ret = (TCU_U10_TEST_CONFIGURATION)this.get("TEST_CONFIGURATION");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * TEST_CONFIGURATION (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public TCU_U10_TEST_CONFIGURATION getTEST_CONFIGURATION(int rep) { 
       TCU_U10_TEST_CONFIGURATION ret = null;
       try {
          ret = (TCU_U10_TEST_CONFIGURATION)this.get("TEST_CONFIGURATION", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of TEST_CONFIGURATION 
     */ 
    public int getTEST_CONFIGURATIONReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("TEST_CONFIGURATION").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of TEST_CONFIGURATION (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertTEST_CONFIGURATION(TCU_U10_TEST_CONFIGURATION structure, int rep) throws HL7Exception { 
       super.insertRepetition( "TEST_CONFIGURATION", structure, rep);
    }


    /**
     * Inserts a specific repetition of TEST_CONFIGURATION (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public TCU_U10_TEST_CONFIGURATION insertTEST_CONFIGURATION(int rep) throws HL7Exception { 
       return (TCU_U10_TEST_CONFIGURATION)super.insertRepetition("TEST_CONFIGURATION", rep);
    }


    /**
     * Removes a specific repetition of TEST_CONFIGURATION (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public TCU_U10_TEST_CONFIGURATION removeTEST_CONFIGURATION(int rep) throws HL7Exception { 
       return (TCU_U10_TEST_CONFIGURATION)super.removeRepetition("TEST_CONFIGURATION", rep);
    }



    /**
     * Returns
     * ROL (Role) - creates it if necessary
     */
    public ROL getROL() { 
       ROL ret = null;
       try {
          ret = (ROL)this.get("ROL");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




}

