/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v25.segment;

// import ca.uhn.hl7v2.model.v25.group.*;
import ca.uhn.hl7v2.model.v25.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 BLG message segment (Billing). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>BLG-1: When to Charge (CCD) <b>optional </b>
     * <li>BLG-2: Charge Type (ID) <b>optional </b>
     * <li>BLG-3: Account ID (CX) <b>optional </b>
     * <li>BLG-4: Charge Type Reason (CWE) <b>optional </b>
 * </ul>
 */
public class BLG extends AbstractSegment {

    /** 
     * Creates a new BLG segment
     */
    public BLG(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(CCD.class, false, 1, 40, new Object[]{ getMessage(), new Integer(100) }, "When to Charge");
                                  this.add(ID.class, false, 1, 50, new Object[]{ getMessage() }, "Charge Type");
                                  this.add(CX.class, false, 1, 100, new Object[]{ getMessage(), new Integer(0) }, "Account ID");
                                  this.add(CWE.class, false, 1, 60, new Object[]{ getMessage(), new Integer(475) }, "Charge Type Reason");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating BLG - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * BLG-1: "When to Charge" - creates it if necessary
     */
    public CCD getWhenToCharge() { 
        CCD ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CCD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BLG-1: "When to Charge" - creates it if necessary
     */
    public CCD getBlg1_WhenToCharge() { 
        CCD ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CCD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BLG-2: "Charge Type" - creates it if necessary
     */
    public ID getChargeType() { 
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BLG-2: "Charge Type" - creates it if necessary
     */
    public ID getBlg2_ChargeType() { 
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BLG-3: "Account ID" - creates it if necessary
     */
    public CX getAccountID() { 
        CX ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BLG-3: "Account ID" - creates it if necessary
     */
    public CX getBlg3_AccountID() { 
        CX ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BLG-4: "Charge Type Reason" - creates it if necessary
     */
    public CWE getChargeTypeReason() { 
        CWE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BLG-4: "Charge Type Reason" - creates it if necessary
     */
    public CWE getBlg4_ChargeTypeReason() { 
        CWE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new CCD(getMessage());
          case 1: return new ID(getMessage(), new Integer( 122 ));
          case 2: return new CX(getMessage());
          case 3: return new CWE(getMessage());
          default: return null;
       }
   }


}

