/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v25.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 AUI (Authorization Information) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Authorization Number (ST)
 * <li>Date (DT)
 * <li>Source (ST)
 * </ul>
 */
public class AUI extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new AUI type
     */
    public AUI(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[3];    
        data[0] = new ST(getMessage());
        data[1] = new DT(getMessage());
        data[2] = new ST(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Authorization Number (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getAuthorizationNumber() {
       ST ret = null;
       try {
          ret = (ST)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Authorization Number (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getAui1_AuthorizationNumber() {
       ST ret = null;
       try {
          ret = (ST)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Date (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public DT getDate() {
       DT ret = null;
       try {
          ret = (DT)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Date (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public DT getAui2_Date() {
       DT ret = null;
       try {
          ret = (DT)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Source (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getSource() {
       ST ret = null;
       try {
          ret = (ST)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Source (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getAui3_Source() {
       ST ret = null;
       try {
          ret = (ST)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

