/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v25.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 EIP (Entity Identifier Pair) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Placer Assigned Identifier (EI)
 * <li>Filler Assigned Identifier (EI)
 * </ul>
 */
public class EIP extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new EIP type
     */
    public EIP(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[2];    
        data[0] = new EI(getMessage());
        data[1] = new EI(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Placer Assigned Identifier (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public EI getPlacerAssignedIdentifier() {
       EI ret = null;
       try {
          ret = (EI)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Placer Assigned Identifier (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public EI getEip1_PlacerAssignedIdentifier() {
       EI ret = null;
       try {
          ret = (EI)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Filler Assigned Identifier (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public EI getFillerAssignedIdentifier() {
       EI ret = null;
       try {
          ret = (EI)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Filler Assigned Identifier (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public EI getEip2_FillerAssignedIdentifier() {
       EI ret = null;
       try {
          ret = (EI)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

