/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v25.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 ERL (Error Location) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Segment ID (ST)
 * <li>Segment Sequence (NM)
 * <li>Field Position (NM)
 * <li>Field Repetition (NM)
 * <li>Component Number (NM)
 * <li>Sub-Component Number (NM)
 * </ul>
 */
public class ERL extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new ERL type
     */
    public ERL(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[6];    
        data[0] = new ST(getMessage());
        data[1] = new NM(getMessage());
        data[2] = new NM(getMessage());
        data[3] = new NM(getMessage());
        data[4] = new NM(getMessage());
        data[5] = new NM(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Segment ID (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getSegmentID() {
       ST ret = null;
       try {
          ret = (ST)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Segment ID (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getErl1_SegmentID() {
       ST ret = null;
       try {
          ret = (ST)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Segment Sequence (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getSegmentSequence() {
       NM ret = null;
       try {
          ret = (NM)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Segment Sequence (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getErl2_SegmentSequence() {
       NM ret = null;
       try {
          ret = (NM)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Field Position (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getFieldPosition() {
       NM ret = null;
       try {
          ret = (NM)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Field Position (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getErl3_FieldPosition() {
       NM ret = null;
       try {
          ret = (NM)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Field Repetition (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getFieldRepetition() {
       NM ret = null;
       try {
          ret = (NM)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Field Repetition (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getErl4_FieldRepetition() {
       NM ret = null;
       try {
          ret = (NM)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Component Number (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getComponentNumber() {
       NM ret = null;
       try {
          ret = (NM)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Component Number (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getErl5_ComponentNumber() {
       NM ret = null;
       try {
          ret = (NM)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Sub-Component Number (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getSubComponentNumber() {
       NM ret = null;
       try {
          ret = (NM)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Sub-Component Number (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getErl6_SubComponentNumber() {
       NM ret = null;
       try {
          ret = (NM)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

