/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.model.v25.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a DFT_P03_FINANCIAL group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: FT1 (Financial Transaction) <b> </b></li>
                 * <li>2: NTE (Notes and Comments) <b>optional </b></li>
                 * <li>3: DFT_P03_FINANCIAL_PROCEDURE (a Group object) <b>optional repeating</b></li>
                 * <li>4: DFT_P03_FINANCIAL_COMMON_ORDER (a Group object) <b>optional repeating</b></li>
 * </ul>
 */
public class DFT_P03_FINANCIAL extends AbstractGroup {

    /** 
     * Creates a new DFT_P03_FINANCIAL group
     */
    public DFT_P03_FINANCIAL(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(FT1.class, true, false);
                          this.add(NTE.class, false, false);
                          this.add(DFT_P03_FINANCIAL_PROCEDURE.class, false, true);
                          this.add(DFT_P03_FINANCIAL_COMMON_ORDER.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating DFT_P03_FINANCIAL - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.5"
     */
    public String getVersion() {
       return "2.5";
    }



    /**
     * Returns
     * FT1 (Financial Transaction) - creates it if necessary
     */
    public FT1 getFT1() { 
       FT1 ret = null;
       try {
          ret = (FT1)this.get("FT1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * NTE (Notes and Comments) - creates it if necessary
     */
    public NTE getNTE() { 
       NTE ret = null;
       try {
          ret = (NTE)this.get("NTE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * FINANCIAL_PROCEDURE (a Group object) - creates it if necessary
     */
    public DFT_P03_FINANCIAL_PROCEDURE getFINANCIAL_PROCEDURE() { 
       DFT_P03_FINANCIAL_PROCEDURE ret = null;
       try {
          ret = (DFT_P03_FINANCIAL_PROCEDURE)this.get("FINANCIAL_PROCEDURE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * FINANCIAL_PROCEDURE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public DFT_P03_FINANCIAL_PROCEDURE getFINANCIAL_PROCEDURE(int rep) { 
       DFT_P03_FINANCIAL_PROCEDURE ret = null;
       try {
          ret = (DFT_P03_FINANCIAL_PROCEDURE)this.get("FINANCIAL_PROCEDURE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of FINANCIAL_PROCEDURE 
     */ 
    public int getFINANCIAL_PROCEDUREReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("FINANCIAL_PROCEDURE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of FINANCIAL_PROCEDURE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertFINANCIAL_PROCEDURE(DFT_P03_FINANCIAL_PROCEDURE structure, int rep) throws HL7Exception { 
       super.insertRepetition("FINANCIAL_PROCEDURE", structure, rep);
    }


    /**
     * Inserts a specific repetition of FINANCIAL_PROCEDURE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public DFT_P03_FINANCIAL_PROCEDURE insertFINANCIAL_PROCEDURE(int rep) throws HL7Exception { 
       return (DFT_P03_FINANCIAL_PROCEDURE)super.insertRepetition("FINANCIAL_PROCEDURE", rep);
    }


    /**
     * Removes a specific repetition of FINANCIAL_PROCEDURE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public DFT_P03_FINANCIAL_PROCEDURE removeFINANCIAL_PROCEDURE(int rep) throws HL7Exception { 
       return (DFT_P03_FINANCIAL_PROCEDURE)super.removeRepetition("FINANCIAL_PROCEDURE", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * FINANCIAL_COMMON_ORDER (a Group object) - creates it if necessary
     */
    public DFT_P03_FINANCIAL_COMMON_ORDER getFINANCIAL_COMMON_ORDER() { 
       DFT_P03_FINANCIAL_COMMON_ORDER ret = null;
       try {
          ret = (DFT_P03_FINANCIAL_COMMON_ORDER)this.get("FINANCIAL_COMMON_ORDER");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * FINANCIAL_COMMON_ORDER (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public DFT_P03_FINANCIAL_COMMON_ORDER getFINANCIAL_COMMON_ORDER(int rep) { 
       DFT_P03_FINANCIAL_COMMON_ORDER ret = null;
       try {
          ret = (DFT_P03_FINANCIAL_COMMON_ORDER)this.get("FINANCIAL_COMMON_ORDER", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of FINANCIAL_COMMON_ORDER 
     */ 
    public int getFINANCIAL_COMMON_ORDERReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("FINANCIAL_COMMON_ORDER").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of FINANCIAL_COMMON_ORDER (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertFINANCIAL_COMMON_ORDER(DFT_P03_FINANCIAL_COMMON_ORDER structure, int rep) throws HL7Exception { 
       super.insertRepetition("FINANCIAL_COMMON_ORDER", structure, rep);
    }


    /**
     * Inserts a specific repetition of FINANCIAL_COMMON_ORDER (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public DFT_P03_FINANCIAL_COMMON_ORDER insertFINANCIAL_COMMON_ORDER(int rep) throws HL7Exception { 
       return (DFT_P03_FINANCIAL_COMMON_ORDER)super.insertRepetition("FINANCIAL_COMMON_ORDER", rep);
    }


    /**
     * Removes a specific repetition of FINANCIAL_COMMON_ORDER (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public DFT_P03_FINANCIAL_COMMON_ORDER removeFINANCIAL_COMMON_ORDER(int rep) throws HL7Exception { 
       return (DFT_P03_FINANCIAL_COMMON_ORDER)super.removeRepetition("FINANCIAL_COMMON_ORDER", rep);
    }



}

