/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v25.message;

import ca.uhn.hl7v2.model.v25.group.*;
import ca.uhn.hl7v2.model.v25.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a SUR_P09 message structure (see chapter 7.11.2). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (Message Header) <b> </b></li>
                 * <li>2: SUR_P09_FACILITY (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class SUR_P09 extends AbstractMessage  {

    /**
     * Creates a new SUR_P09 message with DefaultModelClassFactory. 
     */ 
    public SUR_P09() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new SUR_P09 message with custom ModelClassFactory.
     */
    public SUR_P09(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(SUR_P09_FACILITY.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating SUR_P09 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.5"
     */
    public String getVersion() {
       return "2.5";
    }



    /**
     * Returns
     * MSH (Message Header) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * FACILITY (a Group object) - creates it if necessary
     */
    public SUR_P09_FACILITY getFACILITY() { 
       SUR_P09_FACILITY ret = null;
       try {
          ret = (SUR_P09_FACILITY)this.get("FACILITY");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * FACILITY (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SUR_P09_FACILITY getFACILITY(int rep) { 
       SUR_P09_FACILITY ret = null;
       try {
          ret = (SUR_P09_FACILITY)this.get("FACILITY", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of FACILITY 
     */ 
    public int getFACILITYReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("FACILITY").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of FACILITY (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertFACILITY(SUR_P09_FACILITY structure, int rep) throws HL7Exception { 
       super.insertRepetition( "FACILITY", structure, rep);
    }


    /**
     * Inserts a specific repetition of FACILITY (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public SUR_P09_FACILITY insertFACILITY(int rep) throws HL7Exception { 
       return (SUR_P09_FACILITY)super.insertRepetition("FACILITY", rep);
    }


    /**
     * Removes a specific repetition of FACILITY (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public SUR_P09_FACILITY removeFACILITY(int rep) throws HL7Exception { 
       return (SUR_P09_FACILITY)super.removeRepetition("FACILITY", rep);
    }



}

