/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v25.segment;

// import ca.uhn.hl7v2.model.v25.group.*;
import ca.uhn.hl7v2.model.v25.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 BPX message segment (Blood product dispense status). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>BPX-1: Set ID _ BPX (SI) <b> </b>
     * <li>BPX-2: BP Dispense Status (CWE) <b> </b>
     * <li>BPX-3: BP Status (ID) <b> </b>
     * <li>BPX-4: BP Date/Time of Status (TS) <b> </b>
     * <li>BPX-5: BC Donation ID (EI) <b>optional </b>
     * <li>BPX-6: BC Component (CNE) <b>optional </b>
     * <li>BPX-7: BC Donation Type / Intended Use (CNE) <b>optional </b>
     * <li>BPX-8: CP Commercial Product (CWE) <b>optional </b>
     * <li>BPX-9: CP Manufacturer (XON) <b>optional </b>
     * <li>BPX-10: CP Lot Number (EI) <b>optional </b>
     * <li>BPX-11: BP Blood Group (CNE) <b>optional </b>
     * <li>BPX-12: BC Special Testing (CNE) <b>optional repeating</b>
     * <li>BPX-13: BP Expiration Date/Time (TS) <b>optional </b>
     * <li>BPX-14: BP Quantity (NM) <b> </b>
     * <li>BPX-15: BP Amount (NM) <b>optional </b>
     * <li>BPX-16: BP Units (CE) <b>optional </b>
     * <li>BPX-17: BP Unique ID (EI) <b>optional </b>
     * <li>BPX-18: BP Actual Dispensed To Location (PL) <b>optional </b>
     * <li>BPX-19: BP Actual Dispensed To Address (XAD) <b>optional </b>
     * <li>BPX-20: BP Dispensed to Receiver (XCN) <b>optional </b>
     * <li>BPX-21: BP Dispensing Individual (XCN) <b>optional </b>
 * </ul>
 */
public class BPX extends AbstractSegment {

    /** 
     * Creates a new BPX segment
     */
    public BPX(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, true, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Set ID _ BPX");
                                  this.add(CWE.class, true, 1, 250, new Object[]{ getMessage(), new Integer(510) }, "BP Dispense Status");
                                  this.add(ID.class, true, 1, 1, new Object[]{ getMessage() }, "BP Status");
                                  this.add(TS.class, true, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "BP Date/Time of Status");
                                  this.add(EI.class, false, 1, 22, new Object[]{ getMessage(), new Integer(0) }, "BC Donation ID");
                                  this.add(CNE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "BC Component");
                                  this.add(CNE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "BC Donation Type / Intended Use");
                                  this.add(CWE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(512) }, "CP Commercial Product");
                                  this.add(XON.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "CP Manufacturer");
                                  this.add(EI.class, false, 1, 22, new Object[]{ getMessage(), new Integer(0) }, "CP Lot Number");
                                  this.add(CNE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "BP Blood Group");
                                  this.add(CNE.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "BC Special Testing");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "BP Expiration Date/Time");
                                  this.add(NM.class, true, 1, 5, new Object[]{ getMessage(), new Integer(0) }, "BP Quantity");
                                  this.add(NM.class, false, 1, 5, new Object[]{ getMessage(), new Integer(0) }, "BP Amount");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "BP Units");
                                  this.add(EI.class, false, 1, 22, new Object[]{ getMessage(), new Integer(0) }, "BP Unique ID");
                                  this.add(PL.class, false, 1, 80, new Object[]{ getMessage(), new Integer(0) }, "BP Actual Dispensed To Location");
                                  this.add(XAD.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "BP Actual Dispensed To Address");
                                  this.add(XCN.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "BP Dispensed to Receiver");
                                  this.add(XCN.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "BP Dispensing Individual");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating BPX - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * BPX-1: "Set ID _ BPX" - creates it if necessary
     */
    public SI getSetIDBPX() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BPX-1: "Set ID _ BPX" - creates it if necessary
     */
    public SI getBpx1_SetIDBPX() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BPX-2: "BP Dispense Status" - creates it if necessary
     */
    public CWE getBPDispenseStatus() { 
        CWE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BPX-2: "BP Dispense Status" - creates it if necessary
     */
    public CWE getBpx2_BPDispenseStatus() { 
        CWE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BPX-3: "BP Status" - creates it if necessary
     */
    public ID getBPStatus() { 
        ID ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BPX-3: "BP Status" - creates it if necessary
     */
    public ID getBpx3_BPStatus() { 
        ID ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BPX-4: "BP Date/Time of Status" - creates it if necessary
     */
    public TS getBPDateTimeOfStatus() { 
        TS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BPX-4: "BP Date/Time of Status" - creates it if necessary
     */
    public TS getBpx4_BPDateTimeOfStatus() { 
        TS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BPX-5: "BC Donation ID" - creates it if necessary
     */
    public EI getBCDonationID() { 
        EI ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BPX-5: "BC Donation ID" - creates it if necessary
     */
    public EI getBpx5_BCDonationID() { 
        EI ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BPX-6: "BC Component" - creates it if necessary
     */
    public CNE getBCComponent() { 
        CNE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BPX-6: "BC Component" - creates it if necessary
     */
    public CNE getBpx6_BCComponent() { 
        CNE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BPX-7: "BC Donation Type / Intended Use" - creates it if necessary
     */
    public CNE getBCDonationTypeIntendedUse() { 
        CNE ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BPX-7: "BC Donation Type / Intended Use" - creates it if necessary
     */
    public CNE getBpx7_BCDonationTypeIntendedUse() { 
        CNE ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BPX-8: "CP Commercial Product" - creates it if necessary
     */
    public CWE getCPCommercialProduct() { 
        CWE ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BPX-8: "CP Commercial Product" - creates it if necessary
     */
    public CWE getBpx8_CPCommercialProduct() { 
        CWE ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BPX-9: "CP Manufacturer" - creates it if necessary
     */
    public XON getCPManufacturer() { 
        XON ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BPX-9: "CP Manufacturer" - creates it if necessary
     */
    public XON getBpx9_CPManufacturer() { 
        XON ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BPX-10: "CP Lot Number" - creates it if necessary
     */
    public EI getCPLotNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BPX-10: "CP Lot Number" - creates it if necessary
     */
    public EI getBpx10_CPLotNumber() { 
        EI ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BPX-11: "BP Blood Group" - creates it if necessary
     */
    public CNE getBPBloodGroup() { 
        CNE ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BPX-11: "BP Blood Group" - creates it if necessary
     */
    public CNE getBpx11_BPBloodGroup() { 
        CNE ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of BC Special Testing (BPX-12).
     */
    public CNE[] getBCSpecialTesting() {
        CNE[] ret = null;
        try {
            Type[] t = this.getField(12);  
            ret = new CNE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CNE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of BC Special Testing (BPX-12).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getBCSpecialTestingReps() {
        CNE[] ret = null;
        try {
            Type[] t = this.getField(12);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * BPX-12: "BC Special Testing" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CNE getBCSpecialTesting(int rep) { 
        CNE ret = null;
        try {
            Type t = this.getField(12, rep);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * BPX-12: "BC Special Testing" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CNE getBpx12_BCSpecialTesting(int rep) { 
        CNE ret = null;
        try {
            Type t = this.getField(12, rep);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of BC Special Testing (BPX-12).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getBpx12_BCSpecialTestingReps() {
        CNE[] ret = null;
        try {
            Type[] t = this.getField(12);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * BPX-12: "BC Special Testing" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CNE insertBCSpecialTesting(int rep) throws HL7Exception { 
        return (CNE) super.insertRepetition(12, rep);
    }



    /**
     * Inserts a repetition of
     * BPX-12: "BC Special Testing" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CNE insertBpx12_BCSpecialTesting(int rep) throws HL7Exception { 
        return (CNE) super.insertRepetition(12, rep);
    }


    /**
     * Removes a repetition of
     * BPX-12: "BC Special Testing" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CNE removeBCSpecialTesting(int rep) throws HL7Exception { 
        return (CNE) super.removeRepetition(12, rep);
    }


    /**
     * Removes a repetition of
     * BPX-12: "BC Special Testing" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CNE removeBpx12_BCSpecialTesting(int rep) throws HL7Exception { 
        return (CNE) super.removeRepetition(12, rep);
    }




    /**
     * Returns
     * BPX-13: "BP Expiration Date/Time" - creates it if necessary
     */
    public TS getBPExpirationDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BPX-13: "BP Expiration Date/Time" - creates it if necessary
     */
    public TS getBpx13_BPExpirationDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BPX-14: "BP Quantity" - creates it if necessary
     */
    public NM getBPQuantity() { 
        NM ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BPX-14: "BP Quantity" - creates it if necessary
     */
    public NM getBpx14_BPQuantity() { 
        NM ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BPX-15: "BP Amount" - creates it if necessary
     */
    public NM getBPAmount() { 
        NM ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BPX-15: "BP Amount" - creates it if necessary
     */
    public NM getBpx15_BPAmount() { 
        NM ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BPX-16: "BP Units" - creates it if necessary
     */
    public CE getBPUnits() { 
        CE ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BPX-16: "BP Units" - creates it if necessary
     */
    public CE getBpx16_BPUnits() { 
        CE ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BPX-17: "BP Unique ID" - creates it if necessary
     */
    public EI getBPUniqueID() { 
        EI ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BPX-17: "BP Unique ID" - creates it if necessary
     */
    public EI getBpx17_BPUniqueID() { 
        EI ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BPX-18: "BP Actual Dispensed To Location" - creates it if necessary
     */
    public PL getBPActualDispensedToLocation() { 
        PL ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (PL)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BPX-18: "BP Actual Dispensed To Location" - creates it if necessary
     */
    public PL getBpx18_BPActualDispensedToLocation() { 
        PL ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (PL)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BPX-19: "BP Actual Dispensed To Address" - creates it if necessary
     */
    public XAD getBPActualDispensedToAddress() { 
        XAD ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BPX-19: "BP Actual Dispensed To Address" - creates it if necessary
     */
    public XAD getBpx19_BPActualDispensedToAddress() { 
        XAD ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BPX-20: "BP Dispensed to Receiver" - creates it if necessary
     */
    public XCN getBPDispensedToReceiver() { 
        XCN ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BPX-20: "BP Dispensed to Receiver" - creates it if necessary
     */
    public XCN getBpx20_BPDispensedToReceiver() { 
        XCN ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * BPX-21: "BP Dispensing Individual" - creates it if necessary
     */
    public XCN getBPDispensingIndividual() { 
        XCN ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * BPX-21: "BP Dispensing Individual" - creates it if necessary
     */
    public XCN getBpx21_BPDispensingIndividual() { 
        XCN ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new CWE(getMessage());
          case 2: return new ID(getMessage(), new Integer( 511 ));
          case 3: return new TS(getMessage());
          case 4: return new EI(getMessage());
          case 5: return new CNE(getMessage());
          case 6: return new CNE(getMessage());
          case 7: return new CWE(getMessage());
          case 8: return new XON(getMessage());
          case 9: return new EI(getMessage());
          case 10: return new CNE(getMessage());
          case 11: return new CNE(getMessage());
          case 12: return new TS(getMessage());
          case 13: return new NM(getMessage());
          case 14: return new NM(getMessage());
          case 15: return new CE(getMessage());
          case 16: return new EI(getMessage());
          case 17: return new PL(getMessage());
          case 18: return new XAD(getMessage());
          case 19: return new XCN(getMessage());
          case 20: return new XCN(getMessage());
          default: return null;
       }
   }


}

