/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v25.segment;

// import ca.uhn.hl7v2.model.v25.group.*;
import ca.uhn.hl7v2.model.v25.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 OM3 message segment (Categorical Service/Test/Observation). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>OM3-1: Sequence Number - Test/Observation Master File (NM) <b>optional </b>
     * <li>OM3-2: Preferred Coding System (CE) <b>optional </b>
     * <li>OM3-3: Valid Coded "Answers" (CE) <b>optional </b>
     * <li>OM3-4: Normal Text/Codes for Categorical Observations (CE) <b>optional repeating</b>
     * <li>OM3-5: Abnormal Text/Codes for Categorical Observations (CE) <b>optional repeating</b>
     * <li>OM3-6: Critical Text/Codes for Categorical Observations (CE) <b>optional repeating</b>
     * <li>OM3-7: Value Type (ID) <b>optional </b>
 * </ul>
 */
public class OM3 extends AbstractSegment {

    /** 
     * Creates a new OM3 segment
     */
    public OM3(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Sequence Number - Test/Observation Master File");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(9999) }, "Preferred Coding System");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(9999) }, "Valid Coded \"Answers\"");
                                  this.add(CE.class, false, 0, 250, new Object[]{ getMessage(), new Integer(9999) }, "Normal Text/Codes for Categorical Observations");
                                  this.add(CE.class, false, 0, 250, new Object[]{ getMessage(), new Integer(9999) }, "Abnormal Text/Codes for Categorical Observations");
                                  this.add(CE.class, false, 0, 250, new Object[]{ getMessage(), new Integer(9999) }, "Critical Text/Codes for Categorical Observations");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "Value Type");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating OM3 - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * OM3-1: "Sequence Number - Test/Observation Master File" - creates it if necessary
     */
    public NM getSequenceNumberTestObservationMasterFile() { 
        NM ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM3-1: "Sequence Number - Test/Observation Master File" - creates it if necessary
     */
    public NM getOm31_SequenceNumberTestObservationMasterFile() { 
        NM ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM3-2: "Preferred Coding System" - creates it if necessary
     */
    public CE getPreferredCodingSystem() { 
        CE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM3-2: "Preferred Coding System" - creates it if necessary
     */
    public CE getOm32_PreferredCodingSystem() { 
        CE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OM3-3: "Valid Coded "Answers"" - creates it if necessary
     */
    public CE getValidCodedAnswers() { 
        CE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM3-3: "Valid Coded "Answers"" - creates it if necessary
     */
    public CE getOm33_ValidCodedAnswers() { 
        CE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Normal Text/Codes for Categorical Observations (OM3-4).
     */
    public CE[] getNormalTextCodesForCategoricalObservations() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(4);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Normal Text/Codes for Categorical Observations (OM3-4).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getNormalTextCodesForCategoricalObservationsReps() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(4);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * OM3-4: "Normal Text/Codes for Categorical Observations" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getNormalTextCodesForCategoricalObservations(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OM3-4: "Normal Text/Codes for Categorical Observations" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getOm34_NormalTextCodesForCategoricalObservations(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Normal Text/Codes for Categorical Observations (OM3-4).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getOm34_NormalTextCodesForCategoricalObservationsReps() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(4);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * OM3-4: "Normal Text/Codes for Categorical Observations" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertNormalTextCodesForCategoricalObservations(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(4, rep);
    }



    /**
     * Inserts a repetition of
     * OM3-4: "Normal Text/Codes for Categorical Observations" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertOm34_NormalTextCodesForCategoricalObservations(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * OM3-4: "Normal Text/Codes for Categorical Observations" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeNormalTextCodesForCategoricalObservations(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * OM3-4: "Normal Text/Codes for Categorical Observations" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeOm34_NormalTextCodesForCategoricalObservations(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(4, rep);
    }



    /**
     * Returns all repetitions of Abnormal Text/Codes for Categorical Observations (OM3-5).
     */
    public CE[] getAbnormalTextCodesForCategoricalObservations() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(5);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Abnormal Text/Codes for Categorical Observations (OM3-5).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getAbnormalTextCodesForCategoricalObservationsReps() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(5);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * OM3-5: "Abnormal Text/Codes for Categorical Observations" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getAbnormalTextCodesForCategoricalObservations(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OM3-5: "Abnormal Text/Codes for Categorical Observations" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getOm35_AbnormalTextCodesForCategoricalObservations(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Abnormal Text/Codes for Categorical Observations (OM3-5).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getOm35_AbnormalTextCodesForCategoricalObservationsReps() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(5);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * OM3-5: "Abnormal Text/Codes for Categorical Observations" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertAbnormalTextCodesForCategoricalObservations(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(5, rep);
    }



    /**
     * Inserts a repetition of
     * OM3-5: "Abnormal Text/Codes for Categorical Observations" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertOm35_AbnormalTextCodesForCategoricalObservations(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * OM3-5: "Abnormal Text/Codes for Categorical Observations" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeAbnormalTextCodesForCategoricalObservations(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * OM3-5: "Abnormal Text/Codes for Categorical Observations" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeOm35_AbnormalTextCodesForCategoricalObservations(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(5, rep);
    }



    /**
     * Returns all repetitions of Critical Text/Codes for Categorical Observations (OM3-6).
     */
    public CE[] getCriticalTextCodesForCategoricalObservations() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(6);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Critical Text/Codes for Categorical Observations (OM3-6).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getCriticalTextCodesForCategoricalObservationsReps() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(6);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * OM3-6: "Critical Text/Codes for Categorical Observations" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getCriticalTextCodesForCategoricalObservations(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * OM3-6: "Critical Text/Codes for Categorical Observations" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getOm36_CriticalTextCodesForCategoricalObservations(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Critical Text/Codes for Categorical Observations (OM3-6).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getOm36_CriticalTextCodesForCategoricalObservationsReps() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(6);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * OM3-6: "Critical Text/Codes for Categorical Observations" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertCriticalTextCodesForCategoricalObservations(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(6, rep);
    }



    /**
     * Inserts a repetition of
     * OM3-6: "Critical Text/Codes for Categorical Observations" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertOm36_CriticalTextCodesForCategoricalObservations(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * OM3-6: "Critical Text/Codes for Categorical Observations" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeCriticalTextCodesForCategoricalObservations(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * OM3-6: "Critical Text/Codes for Categorical Observations" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeOm36_CriticalTextCodesForCategoricalObservations(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(6, rep);
    }




    /**
     * Returns
     * OM3-7: "Value Type" - creates it if necessary
     */
    public ID getValueType() { 
        ID ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OM3-7: "Value Type" - creates it if necessary
     */
    public ID getOm37_ValueType() { 
        ID ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new NM(getMessage());
          case 1: return new CE(getMessage());
          case 2: return new CE(getMessage());
          case 3: return new CE(getMessage());
          case 4: return new CE(getMessage());
          case 5: return new CE(getMessage());
          case 6: return new ID(getMessage(), new Integer( 125 ));
          default: return null;
       }
   }


}

