/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v25.segment;

// import ca.uhn.hl7v2.model.v25.group.*;
import ca.uhn.hl7v2.model.v25.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 OVR message segment (Override Segment). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>OVR-1: Business Rule Override Type (CWE) <b>optional </b>
     * <li>OVR-2: Business Rule Override Code (CWE) <b>optional </b>
     * <li>OVR-3: Override Comments (TX) <b>optional </b>
     * <li>OVR-4: Override Entered By (XCN) <b>optional </b>
     * <li>OVR-5: Override Authorized By (XCN) <b>optional </b>
 * </ul>
 */
public class OVR extends AbstractSegment {

    /** 
     * Creates a new OVR segment
     */
    public OVR(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(518) }, "Business Rule Override Type");
                                  this.add(CWE.class, false, 1, 705, new Object[]{ getMessage(), new Integer(521) }, "Business Rule Override Code");
                                  this.add(TX.class, false, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "Override Comments");
                                  this.add(XCN.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Override Entered By");
                                  this.add(XCN.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Override Authorized By");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating OVR - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * OVR-1: "Business Rule Override Type" - creates it if necessary
     */
    public CWE getBusinessRuleOverrideType() { 
        CWE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OVR-1: "Business Rule Override Type" - creates it if necessary
     */
    public CWE getOvr1_BusinessRuleOverrideType() { 
        CWE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OVR-2: "Business Rule Override Code" - creates it if necessary
     */
    public CWE getBusinessRuleOverrideCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OVR-2: "Business Rule Override Code" - creates it if necessary
     */
    public CWE getOvr2_BusinessRuleOverrideCode() { 
        CWE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CWE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OVR-3: "Override Comments" - creates it if necessary
     */
    public TX getOverrideComments() { 
        TX ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OVR-3: "Override Comments" - creates it if necessary
     */
    public TX getOvr3_OverrideComments() { 
        TX ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (TX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OVR-4: "Override Entered By" - creates it if necessary
     */
    public XCN getOverrideEnteredBy() { 
        XCN ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OVR-4: "Override Entered By" - creates it if necessary
     */
    public XCN getOvr4_OverrideEnteredBy() { 
        XCN ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * OVR-5: "Override Authorized By" - creates it if necessary
     */
    public XCN getOverrideAuthorizedBy() { 
        XCN ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * OVR-5: "Override Authorized By" - creates it if necessary
     */
    public XCN getOvr5_OverrideAuthorizedBy() { 
        XCN ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new CWE(getMessage());
          case 1: return new CWE(getMessage());
          case 2: return new TX(getMessage());
          case 3: return new XCN(getMessage());
          case 4: return new XCN(getMessage());
          default: return null;
       }
   }


}

