/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v25.segment;

// import ca.uhn.hl7v2.model.v25.group.*;
import ca.uhn.hl7v2.model.v25.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 RQ1 message segment (Requisition Detail-1). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>RQ1-1: Anticipated Price (ST) <b>optional </b>
     * <li>RQ1-2: Manufacturer Identifier (CE) <b>optional </b>
     * <li>RQ1-3: Manufacturer's Catalog (ST) <b>optional </b>
     * <li>RQ1-4: Vendor ID (CE) <b>optional </b>
     * <li>RQ1-5: Vendor Catalog (ST) <b>optional </b>
     * <li>RQ1-6: Taxable (ID) <b>optional </b>
     * <li>RQ1-7: Substitute Allowed (ID) <b>optional </b>
 * </ul>
 */
public class RQ1 extends AbstractSegment {

    /** 
     * Creates a new RQ1 segment
     */
    public RQ1(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(ST.class, false, 1, 10, new Object[]{ getMessage(), new Integer(0) }, "Anticipated Price");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(385) }, "Manufacturer Identifier");
                                  this.add(ST.class, false, 1, 16, new Object[]{ getMessage(), new Integer(0) }, "Manufacturer's Catalog");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Vendor ID");
                                  this.add(ST.class, false, 1, 16, new Object[]{ getMessage(), new Integer(0) }, "Vendor Catalog");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Taxable");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Substitute Allowed");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RQ1 - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * RQ1-1: "Anticipated Price" - creates it if necessary
     */
    public ST getAnticipatedPrice() { 
        ST ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RQ1-1: "Anticipated Price" - creates it if necessary
     */
    public ST getRq11_AnticipatedPrice() { 
        ST ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RQ1-2: "Manufacturer Identifier" - creates it if necessary
     */
    public CE getManufacturerIdentifier() { 
        CE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RQ1-2: "Manufacturer Identifier" - creates it if necessary
     */
    public CE getRq12_ManufacturerIdentifier() { 
        CE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RQ1-3: "Manufacturer's Catalog" - creates it if necessary
     */
    public ST getManufacturerSCatalog() { 
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RQ1-3: "Manufacturer's Catalog" - creates it if necessary
     */
    public ST getRq13_ManufacturerSCatalog() { 
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RQ1-4: "Vendor ID" - creates it if necessary
     */
    public CE getVendorID() { 
        CE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RQ1-4: "Vendor ID" - creates it if necessary
     */
    public CE getRq14_VendorID() { 
        CE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RQ1-5: "Vendor Catalog" - creates it if necessary
     */
    public ST getVendorCatalog() { 
        ST ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RQ1-5: "Vendor Catalog" - creates it if necessary
     */
    public ST getRq15_VendorCatalog() { 
        ST ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RQ1-6: "Taxable" - creates it if necessary
     */
    public ID getTaxable() { 
        ID ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RQ1-6: "Taxable" - creates it if necessary
     */
    public ID getRq16_Taxable() { 
        ID ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RQ1-7: "Substitute Allowed" - creates it if necessary
     */
    public ID getSubstituteAllowed() { 
        ID ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RQ1-7: "Substitute Allowed" - creates it if necessary
     */
    public ID getRq17_SubstituteAllowed() { 
        ID ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new ST(getMessage());
          case 1: return new CE(getMessage());
          case 2: return new ST(getMessage());
          case 3: return new CE(getMessage());
          case 4: return new ST(getMessage());
          case 5: return new ID(getMessage(), new Integer( 136 ));
          case 6: return new ID(getMessage(), new Integer( 136 ));
          default: return null;
       }
   }


}

