/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v25.segment;

// import ca.uhn.hl7v2.model.v25.group.*;
import ca.uhn.hl7v2.model.v25.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 UB1 message segment (UB82). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>UB1-1: Set ID - UB1 (SI) <b>optional </b>
     * <li>UB1-2: Blood Deductible  (43) (NM) <b>optional </b>
     * <li>UB1-3: Blood Furnished-Pints Of (40) (NM) <b>optional </b>
     * <li>UB1-4: Blood Replaced-Pints (41) (NM) <b>optional </b>
     * <li>UB1-5: Blood Not Replaced-Pints(42) (NM) <b>optional </b>
     * <li>UB1-6: Co-Insurance Days (25) (NM) <b>optional </b>
     * <li>UB1-7: Condition Code (35-39) (IS) <b>optional repeating</b>
     * <li>UB1-8: Covered Days - (23) (NM) <b>optional </b>
     * <li>UB1-9: Non Covered Days - (24) (NM) <b>optional </b>
     * <li>UB1-10: Value Amount & Code (46-49) (UVC) <b>optional repeating</b>
     * <li>UB1-11: Number Of Grace Days (90) (NM) <b>optional </b>
     * <li>UB1-12: Special Program Indicator (44) (CE) <b>optional </b>
     * <li>UB1-13: PSRO/UR Approval Indicator (87) (CE) <b>optional </b>
     * <li>UB1-14: PSRO/UR Approved Stay-Fm (88) (DT) <b>optional </b>
     * <li>UB1-15: PSRO/UR Approved Stay-To (89) (DT) <b>optional </b>
     * <li>UB1-16: Occurrence (28-32) (OCD) <b>optional repeating</b>
     * <li>UB1-17: Occurrence Span (33) (CE) <b>optional </b>
     * <li>UB1-18: Occur Span Start Date(33) (DT) <b>optional </b>
     * <li>UB1-19: Occur Span End Date (33) (DT) <b>optional </b>
     * <li>UB1-20: UB-82 Locator 2 (ST) <b>optional </b>
     * <li>UB1-21: UB-82 Locator 9 (ST) <b>optional </b>
     * <li>UB1-22: UB-82 Locator 27 (ST) <b>optional </b>
     * <li>UB1-23: UB-82 Locator 45 (ST) <b>optional </b>
 * </ul>
 */
public class UB1 extends AbstractSegment {

    /** 
     * Creates a new UB1 segment
     */
    public UB1(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Set ID - UB1");
                                  this.add(NM.class, false, 1, 1, new Object[]{ getMessage(), new Integer(0) }, "Blood Deductible  (43)");
                                  this.add(NM.class, false, 1, 2, new Object[]{ getMessage(), new Integer(0) }, "Blood Furnished-Pints Of (40)");
                                  this.add(NM.class, false, 1, 2, new Object[]{ getMessage(), new Integer(0) }, "Blood Replaced-Pints (41)");
                                  this.add(NM.class, false, 1, 2, new Object[]{ getMessage(), new Integer(0) }, "Blood Not Replaced-Pints(42)");
                                  this.add(NM.class, false, 1, 2, new Object[]{ getMessage(), new Integer(0) }, "Co-Insurance Days (25)");
                                  this.add(IS.class, false, 0, 14, new Object[]{ getMessage() }, "Condition Code (35-39)");
                                  this.add(NM.class, false, 1, 3, new Object[]{ getMessage(), new Integer(0) }, "Covered Days - (23)");
                                  this.add(NM.class, false, 1, 3, new Object[]{ getMessage(), new Integer(0) }, "Non Covered Days - (24)");
                                  this.add(UVC.class, false, 0, 41, new Object[]{ getMessage(), new Integer(0) }, "Value Amount & Code (46-49)");
                                  this.add(NM.class, false, 1, 2, new Object[]{ getMessage(), new Integer(0) }, "Number Of Grace Days (90)");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(348) }, "Special Program Indicator (44)");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(349) }, "PSRO/UR Approval Indicator (87)");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "PSRO/UR Approved Stay-Fm (88)");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "PSRO/UR Approved Stay-To (89)");
                                  this.add(OCD.class, false, 0, 259, new Object[]{ getMessage(), new Integer(0) }, "Occurrence (28-32)");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(351) }, "Occurrence Span (33)");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Occur Span Start Date(33)");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Occur Span End Date (33)");
                                  this.add(ST.class, false, 1, 30, new Object[]{ getMessage(), new Integer(0) }, "UB-82 Locator 2");
                                  this.add(ST.class, false, 1, 7, new Object[]{ getMessage(), new Integer(0) }, "UB-82 Locator 9");
                                  this.add(ST.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "UB-82 Locator 27");
                                  this.add(ST.class, false, 1, 17, new Object[]{ getMessage(), new Integer(0) }, "UB-82 Locator 45");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating UB1 - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * UB1-1: "Set ID - UB1" - creates it if necessary
     */
    public SI getSetIDUB1() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * UB1-1: "Set ID - UB1" - creates it if necessary
     */
    public SI getUb11_SetIDUB1() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * UB1-2: "Blood Deductible  (43)" - creates it if necessary
     */
    public NM getBloodDeductible() { 
        NM ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * UB1-2: "Blood Deductible  (43)" - creates it if necessary
     */
    public NM getUb12_BloodDeductible() { 
        NM ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * UB1-3: "Blood Furnished-Pints Of (40)" - creates it if necessary
     */
    public NM getBloodFurnishedPintsOf() { 
        NM ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * UB1-3: "Blood Furnished-Pints Of (40)" - creates it if necessary
     */
    public NM getUb13_BloodFurnishedPintsOf() { 
        NM ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * UB1-4: "Blood Replaced-Pints (41)" - creates it if necessary
     */
    public NM getBloodReplacedPints() { 
        NM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * UB1-4: "Blood Replaced-Pints (41)" - creates it if necessary
     */
    public NM getUb14_BloodReplacedPints() { 
        NM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * UB1-5: "Blood Not Replaced-Pints(42)" - creates it if necessary
     */
    public NM getBloodNotReplacedPints() { 
        NM ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * UB1-5: "Blood Not Replaced-Pints(42)" - creates it if necessary
     */
    public NM getUb15_BloodNotReplacedPints() { 
        NM ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * UB1-6: "Co-Insurance Days (25)" - creates it if necessary
     */
    public NM getCoInsuranceDays() { 
        NM ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * UB1-6: "Co-Insurance Days (25)" - creates it if necessary
     */
    public NM getUb16_CoInsuranceDays() { 
        NM ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Condition Code (35-39) (UB1-7).
     */
    public IS[] getConditionCode3539() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(7);  
            ret = new IS[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (IS)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Condition Code (35-39) (UB1-7).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getConditionCode3539Reps() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(7);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * UB1-7: "Condition Code (35-39)" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public IS getConditionCode3539(int rep) { 
        IS ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * UB1-7: "Condition Code (35-39)" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public IS getUb17_ConditionCode3539(int rep) { 
        IS ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Condition Code (35-39) (UB1-7).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getUb17_ConditionCode3539Reps() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(7);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * UB1-7: "Condition Code (35-39)" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS insertConditionCode3539(int rep) throws HL7Exception { 
        return (IS) super.insertRepetition(7, rep);
    }



    /**
     * Inserts a repetition of
     * UB1-7: "Condition Code (35-39)" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS insertUb17_ConditionCode3539(int rep) throws HL7Exception { 
        return (IS) super.insertRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * UB1-7: "Condition Code (35-39)" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS removeConditionCode3539(int rep) throws HL7Exception { 
        return (IS) super.removeRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * UB1-7: "Condition Code (35-39)" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS removeUb17_ConditionCode3539(int rep) throws HL7Exception { 
        return (IS) super.removeRepetition(7, rep);
    }




    /**
     * Returns
     * UB1-8: "Covered Days - (23)" - creates it if necessary
     */
    public NM getCoveredDays() { 
        NM ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * UB1-8: "Covered Days - (23)" - creates it if necessary
     */
    public NM getUb18_CoveredDays() { 
        NM ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * UB1-9: "Non Covered Days - (24)" - creates it if necessary
     */
    public NM getNonCoveredDays() { 
        NM ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * UB1-9: "Non Covered Days - (24)" - creates it if necessary
     */
    public NM getUb19_NonCoveredDays() { 
        NM ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Value Amount & Code (46-49) (UB1-10).
     */
    public UVC[] getValueAmountCode4649() {
        UVC[] ret = null;
        try {
            Type[] t = this.getField(10);  
            ret = new UVC[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (UVC)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Value Amount & Code (46-49) (UB1-10).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getValueAmountCode4649Reps() {
        UVC[] ret = null;
        try {
            Type[] t = this.getField(10);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * UB1-10: "Value Amount & Code (46-49)" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public UVC getValueAmountCode4649(int rep) { 
        UVC ret = null;
        try {
            Type t = this.getField(10, rep);
            ret = (UVC)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * UB1-10: "Value Amount & Code (46-49)" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public UVC getUb110_ValueAmountCode4649(int rep) { 
        UVC ret = null;
        try {
            Type t = this.getField(10, rep);
            ret = (UVC)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Value Amount & Code (46-49) (UB1-10).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getUb110_ValueAmountCode4649Reps() {
        UVC[] ret = null;
        try {
            Type[] t = this.getField(10);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * UB1-10: "Value Amount & Code (46-49)" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public UVC insertValueAmountCode4649(int rep) throws HL7Exception { 
        return (UVC) super.insertRepetition(10, rep);
    }



    /**
     * Inserts a repetition of
     * UB1-10: "Value Amount & Code (46-49)" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public UVC insertUb110_ValueAmountCode4649(int rep) throws HL7Exception { 
        return (UVC) super.insertRepetition(10, rep);
    }


    /**
     * Removes a repetition of
     * UB1-10: "Value Amount & Code (46-49)" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public UVC removeValueAmountCode4649(int rep) throws HL7Exception { 
        return (UVC) super.removeRepetition(10, rep);
    }


    /**
     * Removes a repetition of
     * UB1-10: "Value Amount & Code (46-49)" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public UVC removeUb110_ValueAmountCode4649(int rep) throws HL7Exception { 
        return (UVC) super.removeRepetition(10, rep);
    }




    /**
     * Returns
     * UB1-11: "Number Of Grace Days (90)" - creates it if necessary
     */
    public NM getNumberOfGraceDays() { 
        NM ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * UB1-11: "Number Of Grace Days (90)" - creates it if necessary
     */
    public NM getUb111_NumberOfGraceDays() { 
        NM ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * UB1-12: "Special Program Indicator (44)" - creates it if necessary
     */
    public CE getSpecialProgramIndicator() { 
        CE ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * UB1-12: "Special Program Indicator (44)" - creates it if necessary
     */
    public CE getUb112_SpecialProgramIndicator() { 
        CE ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * UB1-13: "PSRO/UR Approval Indicator (87)" - creates it if necessary
     */
    public CE getPSROURApprovalIndicator() { 
        CE ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * UB1-13: "PSRO/UR Approval Indicator (87)" - creates it if necessary
     */
    public CE getUb113_PSROURApprovalIndicator() { 
        CE ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * UB1-14: "PSRO/UR Approved Stay-Fm (88)" - creates it if necessary
     */
    public DT getPSROURApprovedStayFm() { 
        DT ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * UB1-14: "PSRO/UR Approved Stay-Fm (88)" - creates it if necessary
     */
    public DT getUb114_PSROURApprovedStayFm() { 
        DT ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * UB1-15: "PSRO/UR Approved Stay-To (89)" - creates it if necessary
     */
    public DT getPSROURApprovedStayTo() { 
        DT ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * UB1-15: "PSRO/UR Approved Stay-To (89)" - creates it if necessary
     */
    public DT getUb115_PSROURApprovedStayTo() { 
        DT ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Occurrence (28-32) (UB1-16).
     */
    public OCD[] getOccurrence2832() {
        OCD[] ret = null;
        try {
            Type[] t = this.getField(16);  
            ret = new OCD[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (OCD)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Occurrence (28-32) (UB1-16).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getOccurrence2832Reps() {
        OCD[] ret = null;
        try {
            Type[] t = this.getField(16);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * UB1-16: "Occurrence (28-32)" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public OCD getOccurrence2832(int rep) { 
        OCD ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (OCD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * UB1-16: "Occurrence (28-32)" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public OCD getUb116_Occurrence2832(int rep) { 
        OCD ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (OCD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Occurrence (28-32) (UB1-16).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getUb116_Occurrence2832Reps() {
        OCD[] ret = null;
        try {
            Type[] t = this.getField(16);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * UB1-16: "Occurrence (28-32)" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public OCD insertOccurrence2832(int rep) throws HL7Exception { 
        return (OCD) super.insertRepetition(16, rep);
    }



    /**
     * Inserts a repetition of
     * UB1-16: "Occurrence (28-32)" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public OCD insertUb116_Occurrence2832(int rep) throws HL7Exception { 
        return (OCD) super.insertRepetition(16, rep);
    }


    /**
     * Removes a repetition of
     * UB1-16: "Occurrence (28-32)" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public OCD removeOccurrence2832(int rep) throws HL7Exception { 
        return (OCD) super.removeRepetition(16, rep);
    }


    /**
     * Removes a repetition of
     * UB1-16: "Occurrence (28-32)" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public OCD removeUb116_Occurrence2832(int rep) throws HL7Exception { 
        return (OCD) super.removeRepetition(16, rep);
    }




    /**
     * Returns
     * UB1-17: "Occurrence Span (33)" - creates it if necessary
     */
    public CE getOccurrenceSpan() { 
        CE ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * UB1-17: "Occurrence Span (33)" - creates it if necessary
     */
    public CE getUb117_OccurrenceSpan() { 
        CE ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * UB1-18: "Occur Span Start Date(33)" - creates it if necessary
     */
    public DT getOccurSpanStartDate() { 
        DT ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * UB1-18: "Occur Span Start Date(33)" - creates it if necessary
     */
    public DT getUb118_OccurSpanStartDate() { 
        DT ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * UB1-19: "Occur Span End Date (33)" - creates it if necessary
     */
    public DT getOccurSpanEndDate() { 
        DT ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * UB1-19: "Occur Span End Date (33)" - creates it if necessary
     */
    public DT getUb119_OccurSpanEndDate() { 
        DT ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * UB1-20: "UB-82 Locator 2" - creates it if necessary
     */
    public ST getUB82Locator2() { 
        ST ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * UB1-20: "UB-82 Locator 2" - creates it if necessary
     */
    public ST getUb120_UB82Locator2() { 
        ST ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * UB1-21: "UB-82 Locator 9" - creates it if necessary
     */
    public ST getUB82Locator9() { 
        ST ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * UB1-21: "UB-82 Locator 9" - creates it if necessary
     */
    public ST getUb121_UB82Locator9() { 
        ST ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * UB1-22: "UB-82 Locator 27" - creates it if necessary
     */
    public ST getUB82Locator27() { 
        ST ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * UB1-22: "UB-82 Locator 27" - creates it if necessary
     */
    public ST getUb122_UB82Locator27() { 
        ST ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * UB1-23: "UB-82 Locator 45" - creates it if necessary
     */
    public ST getUB82Locator45() { 
        ST ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * UB1-23: "UB-82 Locator 45" - creates it if necessary
     */
    public ST getUb123_UB82Locator45() { 
        ST ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new NM(getMessage());
          case 2: return new NM(getMessage());
          case 3: return new NM(getMessage());
          case 4: return new NM(getMessage());
          case 5: return new NM(getMessage());
          case 6: return new IS(getMessage(), new Integer( 43 ));
          case 7: return new NM(getMessage());
          case 8: return new NM(getMessage());
          case 9: return new UVC(getMessage());
          case 10: return new NM(getMessage());
          case 11: return new CE(getMessage());
          case 12: return new CE(getMessage());
          case 13: return new DT(getMessage());
          case 14: return new DT(getMessage());
          case 15: return new OCD(getMessage());
          case 16: return new CE(getMessage());
          case 17: return new DT(getMessage());
          case 18: return new DT(getMessage());
          case 19: return new ST(getMessage());
          case 20: return new ST(getMessage());
          case 21: return new ST(getMessage());
          case 22: return new ST(getMessage());
          default: return null;
       }
   }


}

