/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.datatype;

import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.DT;
import ca.uhn.hl7v2.model.v25.datatype.IS;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import org.slf4j.LoggerFactory;

public class DLN
extends AbstractType
implements Composite {
    private Type[] data;

    public DLN(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[3];
        this.data[0] = new ST(this.getMessage());
        this.data[1] = new IS(this.getMessage(), 333);
        this.data[2] = new DT(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public ST getLicenseNumber() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(0);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getDln1_LicenseNumber() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(0);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getIssuingStateProvinceCountry() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(1);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getDln2_IssuingStateProvinceCountry() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(1);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DT getExpirationDate() {
        DT ret = null;
        try {
            ret = (DT)this.getComponent(2);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DT getDln3_ExpirationDate() {
        DT ret = null;
        try {
            ret = (DT)this.getComponent(2);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

