/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.datatype;

import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.DR;
import ca.uhn.hl7v2.model.v25.datatype.FN;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.IS;
import ca.uhn.hl7v2.model.v25.datatype.ST;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import org.slf4j.LoggerFactory;

public class XPN
extends AbstractType
implements Composite {
    private Type[] data;

    public XPN(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[14];
        this.data[0] = new FN(this.getMessage());
        this.data[1] = new ST(this.getMessage());
        this.data[2] = new ST(this.getMessage());
        this.data[3] = new ST(this.getMessage());
        this.data[4] = new ST(this.getMessage());
        this.data[5] = new IS(this.getMessage(), 360);
        this.data[6] = new ID(this.getMessage(), 200);
        this.data[7] = new ID(this.getMessage(), 465);
        this.data[8] = new CE(this.getMessage());
        this.data[9] = new DR(this.getMessage());
        this.data[10] = new ID(this.getMessage(), 444);
        this.data[11] = new TS(this.getMessage());
        this.data[12] = new TS(this.getMessage());
        this.data[13] = new ST(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public FN getFamilyName() {
        FN ret = null;
        try {
            ret = (FN)this.getComponent(0);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public FN getXpn1_FamilyName() {
        FN ret = null;
        try {
            ret = (FN)this.getComponent(0);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getGivenName() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(1);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getXpn2_GivenName() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(1);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getSecondAndFurtherGivenNamesOrInitialsThereof() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(2);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getXpn3_SecondAndFurtherGivenNamesOrInitialsThereof() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(2);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getSuffixEgJRorIII() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(3);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getXpn4_SuffixEgJRorIII() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(3);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getPrefixEgDR() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(4);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getXpn5_PrefixEgDR() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(4);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getDegreeEgMD() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(5);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public IS getXpn6_DegreeEgMD() {
        IS ret = null;
        try {
            ret = (IS)this.getComponent(5);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ID getNameTypeCode() {
        ID ret = null;
        try {
            ret = (ID)this.getComponent(6);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ID getXpn7_NameTypeCode() {
        ID ret = null;
        try {
            ret = (ID)this.getComponent(6);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ID getNameRepresentationCode() {
        ID ret = null;
        try {
            ret = (ID)this.getComponent(7);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ID getXpn8_NameRepresentationCode() {
        ID ret = null;
        try {
            ret = (ID)this.getComponent(7);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CE getNameContext() {
        CE ret = null;
        try {
            ret = (CE)this.getComponent(8);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CE getXpn9_NameContext() {
        CE ret = null;
        try {
            ret = (CE)this.getComponent(8);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DR getNameValidityRange() {
        DR ret = null;
        try {
            ret = (DR)this.getComponent(9);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DR getXpn10_NameValidityRange() {
        DR ret = null;
        try {
            ret = (DR)this.getComponent(9);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ID getNameAssemblyOrder() {
        ID ret = null;
        try {
            ret = (ID)this.getComponent(10);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ID getXpn11_NameAssemblyOrder() {
        ID ret = null;
        try {
            ret = (ID)this.getComponent(10);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TS getEffectiveDate() {
        TS ret = null;
        try {
            ret = (TS)this.getComponent(11);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TS getXpn12_EffectiveDate() {
        TS ret = null;
        try {
            ret = (TS)this.getComponent(11);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TS getExpirationDate() {
        TS ret = null;
        try {
            ret = (TS)this.getComponent(12);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TS getXpn13_ExpirationDate() {
        TS ret = null;
        try {
            ret = (TS)this.getComponent(12);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getProfessionalSuffix() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(13);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getXpn14_ProfessionalSuffix() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(13);
        }
        catch (DataTypeException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem accessing known data type component - this is a bug.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

