/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.BRP_O30_TIMING;
import ca.uhn.hl7v2.model.v25.segment.BPO;
import ca.uhn.hl7v2.model.v25.segment.BPX;
import ca.uhn.hl7v2.model.v25.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BRP_O30_ORDER
extends AbstractGroup {
    public BRP_O30_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false);
            this.add(BRP_O30_TIMING.class, false, true);
            this.add(BPO.class, false, false);
            this.add(BPX.class, false, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating BRP_O30_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public BRP_O30_TIMING getTIMING() {
        BRP_O30_TIMING ret = null;
        try {
            ret = (BRP_O30_TIMING)this.get("TIMING");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public BRP_O30_TIMING getTIMING(int rep) {
        BRP_O30_TIMING ret = null;
        try {
            ret = (BRP_O30_TIMING)this.get("TIMING", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getTIMINGReps() {
        int reps = -1;
        try {
            reps = this.getAll("TIMING").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<BRP_O30_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", BRP_O30_TIMING.class);
    }

    public void insertTIMING(BRP_O30_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public BRP_O30_TIMING insertTIMING(int rep) throws HL7Exception {
        return (BRP_O30_TIMING)super.insertRepetition("TIMING", rep);
    }

    public BRP_O30_TIMING removeTIMING(int rep) throws HL7Exception {
        return (BRP_O30_TIMING)super.removeRepetition("TIMING", rep);
    }

    public BPO getBPO() {
        BPO ret = null;
        try {
            ret = (BPO)this.get("BPO");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public BPX getBPX() {
        BPX ret = null;
        try {
            ret = (BPX)this.get("BPX");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public BPX getBPX(int rep) {
        BPX ret = null;
        try {
            ret = (BPX)this.get("BPX", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getBPXReps() {
        int reps = -1;
        try {
            reps = this.getAll("BPX").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<BPX> getBPXAll() throws HL7Exception {
        return this.getAllAsList("BPX", BPX.class);
    }

    public void insertBPX(BPX structure, int rep) throws HL7Exception {
        super.insertRepetition("BPX", (Structure)structure, rep);
    }

    public BPX insertBPX(int rep) throws HL7Exception {
        return (BPX)super.insertRepetition("BPX", rep);
    }

    public BPX removeBPX(int rep) throws HL7Exception {
        return (BPX)super.removeRepetition("BPX", rep);
    }
}

