/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.segment.CM0;
import ca.uhn.hl7v2.model.v25.segment.CM2;
import ca.uhn.hl7v2.model.v25.segment.MFE;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFN_M07_MF_CLIN_STUDY_SCHED
extends AbstractGroup {
    public MFN_M07_MF_CLIN_STUDY_SCHED(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MFE.class, true, false);
            this.add(CM0.class, true, false);
            this.add(CM2.class, false, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating MFN_M07_MF_CLIN_STUDY_SCHED - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public MFE getMFE() {
        MFE ret = null;
        try {
            ret = (MFE)this.get("MFE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CM0 getCM0() {
        CM0 ret = null;
        try {
            ret = (CM0)this.get("CM0");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CM2 getCM2() {
        CM2 ret = null;
        try {
            ret = (CM2)this.get("CM2");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CM2 getCM2(int rep) {
        CM2 ret = null;
        try {
            ret = (CM2)this.get("CM2", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getCM2Reps() {
        int reps = -1;
        try {
            reps = this.getAll("CM2").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<CM2> getCM2All() throws HL7Exception {
        return this.getAllAsList("CM2", CM2.class);
    }

    public void insertCM2(CM2 structure, int rep) throws HL7Exception {
        super.insertRepetition("CM2", (Structure)structure, rep);
    }

    public CM2 insertCM2(int rep) throws HL7Exception {
        return (CM2)super.insertRepetition("CM2", rep);
    }

    public CM2 removeCM2(int rep) throws HL7Exception {
        return (CM2)super.removeRepetition("CM2", rep);
    }
}

