/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.ORD_O04_TIMING_TRAY;
import ca.uhn.hl7v2.model.v25.segment.NTE;
import ca.uhn.hl7v2.model.v25.segment.ODT;
import ca.uhn.hl7v2.model.v25.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORD_O04_ORDER_TRAY
extends AbstractGroup {
    public ORD_O04_ORDER_TRAY(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false);
            this.add(ORD_O04_TIMING_TRAY.class, false, true);
            this.add(ODT.class, false, true);
            this.add(NTE.class, false, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating ORD_O04_ORDER_TRAY - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORD_O04_TIMING_TRAY getTIMING_TRAY() {
        ORD_O04_TIMING_TRAY ret = null;
        try {
            ret = (ORD_O04_TIMING_TRAY)this.get("TIMING_TRAY");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORD_O04_TIMING_TRAY getTIMING_TRAY(int rep) {
        ORD_O04_TIMING_TRAY ret = null;
        try {
            ret = (ORD_O04_TIMING_TRAY)this.get("TIMING_TRAY", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getTIMING_TRAYReps() {
        int reps = -1;
        try {
            reps = this.getAll("TIMING_TRAY").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<ORD_O04_TIMING_TRAY> getTIMING_TRAYAll() throws HL7Exception {
        return this.getAllAsList("TIMING_TRAY", ORD_O04_TIMING_TRAY.class);
    }

    public void insertTIMING_TRAY(ORD_O04_TIMING_TRAY structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING_TRAY", (Structure)structure, rep);
    }

    public ORD_O04_TIMING_TRAY insertTIMING_TRAY(int rep) throws HL7Exception {
        return (ORD_O04_TIMING_TRAY)super.insertRepetition("TIMING_TRAY", rep);
    }

    public ORD_O04_TIMING_TRAY removeTIMING_TRAY(int rep) throws HL7Exception {
        return (ORD_O04_TIMING_TRAY)super.removeRepetition("TIMING_TRAY", rep);
    }

    public ODT getODT() {
        ODT ret = null;
        try {
            ret = (ODT)this.get("ODT");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ODT getODT(int rep) {
        ODT ret = null;
        try {
            ret = (ODT)this.get("ODT", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getODTReps() {
        int reps = -1;
        try {
            reps = this.getAll("ODT").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<ODT> getODTAll() throws HL7Exception {
        return this.getAllAsList("ODT", ODT.class);
    }

    public void insertODT(ODT structure, int rep) throws HL7Exception {
        super.insertRepetition("ODT", (Structure)structure, rep);
    }

    public ODT insertODT(int rep) throws HL7Exception {
        return (ODT)super.insertRepetition("ODT", rep);
    }

    public ODT removeODT(int rep) throws HL7Exception {
        return (ODT)super.removeRepetition("ODT", rep);
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }
}

