/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.segment.SAC;
import ca.uhn.hl7v2.model.v25.segment.SPM;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORG_O20_SPECIMEN
extends AbstractGroup {
    public ORG_O20_SPECIMEN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SPM.class, true, false);
            this.add(SAC.class, false, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating ORG_O20_SPECIMEN - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public SPM getSPM() {
        SPM ret = null;
        try {
            ret = (SPM)this.get("SPM");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SAC getSAC() {
        SAC ret = null;
        try {
            ret = (SAC)this.get("SAC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SAC getSAC(int rep) {
        SAC ret = null;
        try {
            ret = (SAC)this.get("SAC", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSACReps() {
        int reps = -1;
        try {
            reps = this.getAll("SAC").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<SAC> getSACAll() throws HL7Exception {
        return this.getAllAsList("SAC", SAC.class);
    }

    public void insertSAC(SAC structure, int rep) throws HL7Exception {
        super.insertRepetition("SAC", (Structure)structure, rep);
    }

    public SAC insertSAC(int rep) throws HL7Exception {
        return (SAC)super.insertRepetition("SAC", rep);
    }

    public SAC removeSAC(int rep) throws HL7Exception {
        return (SAC)super.removeRepetition("SAC", rep);
    }
}

