/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.ORI_O24_ORDER;
import ca.uhn.hl7v2.model.v25.group.ORI_O24_PATIENT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORI_O24_RESPONSE
extends AbstractGroup {
    public ORI_O24_RESPONSE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORI_O24_PATIENT.class, false, false);
            this.add(ORI_O24_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating ORI_O24_RESPONSE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public ORI_O24_PATIENT getPATIENT() {
        ORI_O24_PATIENT ret = null;
        try {
            ret = (ORI_O24_PATIENT)this.get("PATIENT");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORI_O24_ORDER getORDER() {
        ORI_O24_ORDER ret = null;
        try {
            ret = (ORI_O24_ORDER)this.get("ORDER");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORI_O24_ORDER getORDER(int rep) {
        ORI_O24_ORDER ret = null;
        try {
            ret = (ORI_O24_ORDER)this.get("ORDER", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORDERReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<ORI_O24_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", ORI_O24_ORDER.class);
    }

    public void insertORDER(ORI_O24_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", (Structure)structure, rep);
    }

    public ORI_O24_ORDER insertORDER(int rep) throws HL7Exception {
        return (ORI_O24_ORDER)super.insertRepetition("ORDER", rep);
    }

    public ORI_O24_ORDER removeORDER(int rep) throws HL7Exception {
        return (ORI_O24_ORDER)super.removeRepetition("ORDER", rep);
    }
}

