/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.ORL_O34_OBSERVATION_REQUEST;
import ca.uhn.hl7v2.model.v25.group.ORL_O34_TIMING;
import ca.uhn.hl7v2.model.v25.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORL_O34_ORDER
extends AbstractGroup {
    public ORL_O34_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false);
            this.add(ORL_O34_TIMING.class, false, true);
            this.add(ORL_O34_OBSERVATION_REQUEST.class, false, false);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating ORL_O34_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORL_O34_TIMING getTIMING() {
        ORL_O34_TIMING ret = null;
        try {
            ret = (ORL_O34_TIMING)this.get("TIMING");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORL_O34_TIMING getTIMING(int rep) {
        ORL_O34_TIMING ret = null;
        try {
            ret = (ORL_O34_TIMING)this.get("TIMING", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getTIMINGReps() {
        int reps = -1;
        try {
            reps = this.getAll("TIMING").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<ORL_O34_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", ORL_O34_TIMING.class);
    }

    public void insertTIMING(ORL_O34_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public ORL_O34_TIMING insertTIMING(int rep) throws HL7Exception {
        return (ORL_O34_TIMING)super.insertRepetition("TIMING", rep);
    }

    public ORL_O34_TIMING removeTIMING(int rep) throws HL7Exception {
        return (ORL_O34_TIMING)super.removeRepetition("TIMING", rep);
    }

    public ORL_O34_OBSERVATION_REQUEST getOBSERVATION_REQUEST() {
        ORL_O34_OBSERVATION_REQUEST ret = null;
        try {
            ret = (ORL_O34_OBSERVATION_REQUEST)this.get("OBSERVATION_REQUEST");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

