/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.ORP_O10_ORDER;
import ca.uhn.hl7v2.model.v25.group.ORP_O10_PATIENT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORP_O10_RESPONSE
extends AbstractGroup {
    public ORP_O10_RESPONSE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORP_O10_PATIENT.class, false, false);
            this.add(ORP_O10_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating ORP_O10_RESPONSE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public ORP_O10_PATIENT getPATIENT() {
        ORP_O10_PATIENT ret = null;
        try {
            ret = (ORP_O10_PATIENT)this.get("PATIENT");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORP_O10_ORDER getORDER() {
        ORP_O10_ORDER ret = null;
        try {
            ret = (ORP_O10_ORDER)this.get("ORDER");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORP_O10_ORDER getORDER(int rep) {
        ORP_O10_ORDER ret = null;
        try {
            ret = (ORP_O10_ORDER)this.get("ORDER", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORDERReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<ORP_O10_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", ORP_O10_ORDER.class);
    }

    public void insertORDER(ORP_O10_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", (Structure)structure, rep);
    }

    public ORP_O10_ORDER insertORDER(int rep) throws HL7Exception {
        return (ORP_O10_ORDER)super.insertRepetition("ORDER", rep);
    }

    public ORP_O10_ORDER removeORDER(int rep) throws HL7Exception {
        return (ORP_O10_ORDER)super.removeRepetition("ORDER", rep);
    }
}

