/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.PPV_PCA_GOAL;
import ca.uhn.hl7v2.model.v25.group.PPV_PCA_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v25.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PPV_PCA_PATIENT
extends AbstractGroup {
    public PPV_PCA_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false);
            this.add(PPV_PCA_PATIENT_VISIT.class, false, false);
            this.add(PPV_PCA_GOAL.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating PPV_PCA_PATIENT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPV_PCA_PATIENT_VISIT getPATIENT_VISIT() {
        PPV_PCA_PATIENT_VISIT ret = null;
        try {
            ret = (PPV_PCA_PATIENT_VISIT)this.get("PATIENT_VISIT");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPV_PCA_GOAL getGOAL() {
        PPV_PCA_GOAL ret = null;
        try {
            ret = (PPV_PCA_GOAL)this.get("GOAL");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPV_PCA_GOAL getGOAL(int rep) {
        PPV_PCA_GOAL ret = null;
        try {
            ret = (PPV_PCA_GOAL)this.get("GOAL", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getGOALReps() {
        int reps = -1;
        try {
            reps = this.getAll("GOAL").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<PPV_PCA_GOAL> getGOALAll() throws HL7Exception {
        return this.getAllAsList("GOAL", PPV_PCA_GOAL.class);
    }

    public void insertGOAL(PPV_PCA_GOAL structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL", (Structure)structure, rep);
    }

    public PPV_PCA_GOAL insertGOAL(int rep) throws HL7Exception {
        return (PPV_PCA_GOAL)super.insertRepetition("GOAL", rep);
    }

    public PPV_PCA_GOAL removeGOAL(int rep) throws HL7Exception {
        return (PPV_PCA_GOAL)super.removeRepetition("GOAL", rep);
    }
}

