/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.RRE_O12_ENCODING;
import ca.uhn.hl7v2.model.v25.group.RRE_O12_TIMING;
import ca.uhn.hl7v2.model.v25.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RRE_O12_ORDER
extends AbstractGroup {
    public RRE_O12_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false);
            this.add(RRE_O12_TIMING.class, false, true);
            this.add(RRE_O12_ENCODING.class, false, false);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating RRE_O12_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RRE_O12_TIMING getTIMING() {
        RRE_O12_TIMING ret = null;
        try {
            ret = (RRE_O12_TIMING)this.get("TIMING");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RRE_O12_TIMING getTIMING(int rep) {
        RRE_O12_TIMING ret = null;
        try {
            ret = (RRE_O12_TIMING)this.get("TIMING", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getTIMINGReps() {
        int reps = -1;
        try {
            reps = this.getAll("TIMING").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<RRE_O12_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", RRE_O12_TIMING.class);
    }

    public void insertTIMING(RRE_O12_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public RRE_O12_TIMING insertTIMING(int rep) throws HL7Exception {
        return (RRE_O12_TIMING)super.insertRepetition("TIMING", rep);
    }

    public RRE_O12_TIMING removeTIMING(int rep) throws HL7Exception {
        return (RRE_O12_TIMING)super.removeRepetition("TIMING", rep);
    }

    public RRE_O12_ENCODING getENCODING() {
        RRE_O12_ENCODING ret = null;
        try {
            ret = (RRE_O12_ENCODING)this.get("ENCODING");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

