/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.RSP_Z86_ADMINISTRATION;
import ca.uhn.hl7v2.model.v25.group.RSP_Z86_DISPENSE;
import ca.uhn.hl7v2.model.v25.group.RSP_Z86_ENCODED_ORDER;
import ca.uhn.hl7v2.model.v25.group.RSP_Z86_GIVE;
import ca.uhn.hl7v2.model.v25.group.RSP_Z86_OBSERVATION;
import ca.uhn.hl7v2.model.v25.group.RSP_Z86_ORDER_DETAIL;
import ca.uhn.hl7v2.model.v25.group.RSP_Z86_TIMING;
import ca.uhn.hl7v2.model.v25.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSP_Z86_COMMON_ORDER
extends AbstractGroup {
    public RSP_Z86_COMMON_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false);
            this.add(RSP_Z86_TIMING.class, false, true);
            this.add(RSP_Z86_ORDER_DETAIL.class, false, false);
            this.add(RSP_Z86_ENCODED_ORDER.class, false, false);
            this.add(RSP_Z86_DISPENSE.class, false, false);
            this.add(RSP_Z86_GIVE.class, false, false);
            this.add(RSP_Z86_ADMINISTRATION.class, false, false);
            this.add(RSP_Z86_OBSERVATION.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating RSP_Z86_COMMON_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z86_TIMING getTIMING() {
        RSP_Z86_TIMING ret = null;
        try {
            ret = (RSP_Z86_TIMING)this.get("TIMING");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z86_TIMING getTIMING(int rep) {
        RSP_Z86_TIMING ret = null;
        try {
            ret = (RSP_Z86_TIMING)this.get("TIMING", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getTIMINGReps() {
        int reps = -1;
        try {
            reps = this.getAll("TIMING").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<RSP_Z86_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", RSP_Z86_TIMING.class);
    }

    public void insertTIMING(RSP_Z86_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public RSP_Z86_TIMING insertTIMING(int rep) throws HL7Exception {
        return (RSP_Z86_TIMING)super.insertRepetition("TIMING", rep);
    }

    public RSP_Z86_TIMING removeTIMING(int rep) throws HL7Exception {
        return (RSP_Z86_TIMING)super.removeRepetition("TIMING", rep);
    }

    public RSP_Z86_ORDER_DETAIL getORDER_DETAIL() {
        RSP_Z86_ORDER_DETAIL ret = null;
        try {
            ret = (RSP_Z86_ORDER_DETAIL)this.get("ORDER_DETAIL");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z86_ENCODED_ORDER getENCODED_ORDER() {
        RSP_Z86_ENCODED_ORDER ret = null;
        try {
            ret = (RSP_Z86_ENCODED_ORDER)this.get("ENCODED_ORDER");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z86_DISPENSE getDISPENSE() {
        RSP_Z86_DISPENSE ret = null;
        try {
            ret = (RSP_Z86_DISPENSE)this.get("DISPENSE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z86_GIVE getGIVE() {
        RSP_Z86_GIVE ret = null;
        try {
            ret = (RSP_Z86_GIVE)this.get("GIVE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z86_ADMINISTRATION getADMINISTRATION() {
        RSP_Z86_ADMINISTRATION ret = null;
        try {
            ret = (RSP_Z86_ADMINISTRATION)this.get("ADMINISTRATION");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z86_OBSERVATION getOBSERVATION() {
        RSP_Z86_OBSERVATION ret = null;
        try {
            ret = (RSP_Z86_OBSERVATION)this.get("OBSERVATION");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z86_OBSERVATION getOBSERVATION(int rep) {
        RSP_Z86_OBSERVATION ret = null;
        try {
            ret = (RSP_Z86_OBSERVATION)this.get("OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<RSP_Z86_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", RSP_Z86_OBSERVATION.class);
    }

    public void insertOBSERVATION(RSP_Z86_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public RSP_Z86_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (RSP_Z86_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public RSP_Z86_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (RSP_Z86_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }
}

