/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.ADT_A06_INSURANCE;
import ca.uhn.hl7v2.model.v25.group.ADT_A06_PROCEDURE;
import ca.uhn.hl7v2.model.v25.segment.ACC;
import ca.uhn.hl7v2.model.v25.segment.AL1;
import ca.uhn.hl7v2.model.v25.segment.DB1;
import ca.uhn.hl7v2.model.v25.segment.DG1;
import ca.uhn.hl7v2.model.v25.segment.DRG;
import ca.uhn.hl7v2.model.v25.segment.EVN;
import ca.uhn.hl7v2.model.v25.segment.GT1;
import ca.uhn.hl7v2.model.v25.segment.MRG;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.model.v25.segment.NK1;
import ca.uhn.hl7v2.model.v25.segment.OBX;
import ca.uhn.hl7v2.model.v25.segment.PD1;
import ca.uhn.hl7v2.model.v25.segment.PID;
import ca.uhn.hl7v2.model.v25.segment.PV1;
import ca.uhn.hl7v2.model.v25.segment.PV2;
import ca.uhn.hl7v2.model.v25.segment.ROL;
import ca.uhn.hl7v2.model.v25.segment.SFT;
import ca.uhn.hl7v2.model.v25.segment.UB1;
import ca.uhn.hl7v2.model.v25.segment.UB2;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADT_A06
extends AbstractMessage {
    public ADT_A06() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public ADT_A06(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(EVN.class, true, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(ROL.class, false, true);
            this.add(MRG.class, false, false);
            this.add(NK1.class, false, true);
            this.add(PV1.class, true, false);
            this.add(PV2.class, false, false);
            this.add(ROL.class, false, true);
            this.add(DB1.class, false, true);
            this.add(OBX.class, false, true);
            this.add(AL1.class, false, true);
            this.add(DG1.class, false, true);
            this.add(DRG.class, false, false);
            this.add(ADT_A06_PROCEDURE.class, false, true);
            this.add(GT1.class, false, true);
            this.add(ADT_A06_INSURANCE.class, false, true);
            this.add(ACC.class, false, false);
            this.add(UB1.class, false, false);
            this.add(UB2.class, false, false);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating ADT_A06 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SFT getSFT() {
        SFT ret = null;
        try {
            ret = (SFT)this.get("SFT");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SFT getSFT(int rep) {
        SFT ret = null;
        try {
            ret = (SFT)this.get("SFT", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSFTReps() {
        int reps = -1;
        try {
            reps = this.getAll("SFT").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public EVN getEVN() {
        EVN ret = null;
        try {
            ret = (EVN)this.get("EVN");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PD1 getPD1() {
        PD1 ret = null;
        try {
            ret = (PD1)this.get("PD1");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ROL getROL() {
        ROL ret = null;
        try {
            ret = (ROL)this.get("ROL");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ROL getROL(int rep) {
        ROL ret = null;
        try {
            ret = (ROL)this.get("ROL", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getROLReps() {
        int reps = -1;
        try {
            reps = this.getAll("ROL").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", (Structure)structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public MRG getMRG() {
        MRG ret = null;
        try {
            ret = (MRG)this.get("MRG");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NK1 getNK1() {
        NK1 ret = null;
        try {
            ret = (NK1)this.get("NK1");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NK1 getNK1(int rep) {
        NK1 ret = null;
        try {
            ret = (NK1)this.get("NK1", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNK1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("NK1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", (Structure)structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public PV1 getPV1() {
        PV1 ret = null;
        try {
            ret = (PV1)this.get("PV1");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PV2 getPV2() {
        PV2 ret = null;
        try {
            ret = (PV2)this.get("PV2");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ROL getROL2() {
        ROL ret = null;
        try {
            ret = (ROL)this.get("ROL2");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ROL getROL2(int rep) {
        ROL ret = null;
        try {
            ret = (ROL)this.get("ROL2", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getROL2Reps() {
        int reps = -1;
        try {
            reps = this.getAll("ROL2").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<ROL> getROL2All() throws HL7Exception {
        return this.getAllAsList("ROL2", ROL.class);
    }

    public void insertROL2(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL2", (Structure)structure, rep);
    }

    public ROL insertROL2(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL2", rep);
    }

    public ROL removeROL2(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL2", rep);
    }

    public DB1 getDB1() {
        DB1 ret = null;
        try {
            ret = (DB1)this.get("DB1");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DB1 getDB1(int rep) {
        DB1 ret = null;
        try {
            ret = (DB1)this.get("DB1", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getDB1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("DB1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<DB1> getDB1All() throws HL7Exception {
        return this.getAllAsList("DB1", DB1.class);
    }

    public void insertDB1(DB1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DB1", (Structure)structure, rep);
    }

    public DB1 insertDB1(int rep) throws HL7Exception {
        return (DB1)super.insertRepetition("DB1", rep);
    }

    public DB1 removeDB1(int rep) throws HL7Exception {
        return (DB1)super.removeRepetition("DB1", rep);
    }

    public OBX getOBX() {
        OBX ret = null;
        try {
            ret = (OBX)this.get("OBX");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OBX getOBX(int rep) {
        OBX ret = null;
        try {
            ret = (OBX)this.get("OBX", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBXReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBX").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", (Structure)structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }

    public AL1 getAL1() {
        AL1 ret = null;
        try {
            ret = (AL1)this.get("AL1");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public AL1 getAL1(int rep) {
        AL1 ret = null;
        try {
            ret = (AL1)this.get("AL1", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getAL1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("AL1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<AL1> getAL1All() throws HL7Exception {
        return this.getAllAsList("AL1", AL1.class);
    }

    public void insertAL1(AL1 structure, int rep) throws HL7Exception {
        super.insertRepetition("AL1", (Structure)structure, rep);
    }

    public AL1 insertAL1(int rep) throws HL7Exception {
        return (AL1)super.insertRepetition("AL1", rep);
    }

    public AL1 removeAL1(int rep) throws HL7Exception {
        return (AL1)super.removeRepetition("AL1", rep);
    }

    public DG1 getDG1() {
        DG1 ret = null;
        try {
            ret = (DG1)this.get("DG1");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DG1 getDG1(int rep) {
        DG1 ret = null;
        try {
            ret = (DG1)this.get("DG1", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getDG1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("DG1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<DG1> getDG1All() throws HL7Exception {
        return this.getAllAsList("DG1", DG1.class);
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", (Structure)structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public DRG getDRG() {
        DRG ret = null;
        try {
            ret = (DRG)this.get("DRG");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ADT_A06_PROCEDURE getPROCEDURE() {
        ADT_A06_PROCEDURE ret = null;
        try {
            ret = (ADT_A06_PROCEDURE)this.get("PROCEDURE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ADT_A06_PROCEDURE getPROCEDURE(int rep) {
        ADT_A06_PROCEDURE ret = null;
        try {
            ret = (ADT_A06_PROCEDURE)this.get("PROCEDURE", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPROCEDUREReps() {
        int reps = -1;
        try {
            reps = this.getAll("PROCEDURE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<ADT_A06_PROCEDURE> getPROCEDUREAll() throws HL7Exception {
        return this.getAllAsList("PROCEDURE", ADT_A06_PROCEDURE.class);
    }

    public void insertPROCEDURE(ADT_A06_PROCEDURE structure, int rep) throws HL7Exception {
        super.insertRepetition("PROCEDURE", (Structure)structure, rep);
    }

    public ADT_A06_PROCEDURE insertPROCEDURE(int rep) throws HL7Exception {
        return (ADT_A06_PROCEDURE)super.insertRepetition("PROCEDURE", rep);
    }

    public ADT_A06_PROCEDURE removePROCEDURE(int rep) throws HL7Exception {
        return (ADT_A06_PROCEDURE)super.removeRepetition("PROCEDURE", rep);
    }

    public GT1 getGT1() {
        GT1 ret = null;
        try {
            ret = (GT1)this.get("GT1");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public GT1 getGT1(int rep) {
        GT1 ret = null;
        try {
            ret = (GT1)this.get("GT1", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getGT1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("GT1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<GT1> getGT1All() throws HL7Exception {
        return this.getAllAsList("GT1", GT1.class);
    }

    public void insertGT1(GT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("GT1", (Structure)structure, rep);
    }

    public GT1 insertGT1(int rep) throws HL7Exception {
        return (GT1)super.insertRepetition("GT1", rep);
    }

    public GT1 removeGT1(int rep) throws HL7Exception {
        return (GT1)super.removeRepetition("GT1", rep);
    }

    public ADT_A06_INSURANCE getINSURANCE() {
        ADT_A06_INSURANCE ret = null;
        try {
            ret = (ADT_A06_INSURANCE)this.get("INSURANCE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ADT_A06_INSURANCE getINSURANCE(int rep) {
        ADT_A06_INSURANCE ret = null;
        try {
            ret = (ADT_A06_INSURANCE)this.get("INSURANCE", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getINSURANCEReps() {
        int reps = -1;
        try {
            reps = this.getAll("INSURANCE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<ADT_A06_INSURANCE> getINSURANCEAll() throws HL7Exception {
        return this.getAllAsList("INSURANCE", ADT_A06_INSURANCE.class);
    }

    public void insertINSURANCE(ADT_A06_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", (Structure)structure, rep);
    }

    public ADT_A06_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (ADT_A06_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public ADT_A06_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (ADT_A06_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public ACC getACC() {
        ACC ret = null;
        try {
            ret = (ACC)this.get("ACC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public UB1 getUB1() {
        UB1 ret = null;
        try {
            ret = (UB1)this.get("UB1");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public UB2 getUB2() {
        UB2 ret = null;
        try {
            ret = (UB2)this.get("UB2");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

