/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.MFN_Znn_MF_SITE_DEFINED;
import ca.uhn.hl7v2.model.v25.segment.MFI;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.model.v25.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFN_Znn
extends AbstractMessage {
    public MFN_Znn() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public MFN_Znn(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(MFI.class, true, false);
            this.add(MFN_Znn_MF_SITE_DEFINED.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating MFN_Znn - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SFT getSFT() {
        SFT ret = null;
        try {
            ret = (SFT)this.get("SFT");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SFT getSFT(int rep) {
        SFT ret = null;
        try {
            ret = (SFT)this.get("SFT", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSFTReps() {
        int reps = -1;
        try {
            reps = this.getAll("SFT").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public MFI getMFI() {
        MFI ret = null;
        try {
            ret = (MFI)this.get("MFI");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_Znn_MF_SITE_DEFINED getMF_SITE_DEFINED() {
        MFN_Znn_MF_SITE_DEFINED ret = null;
        try {
            ret = (MFN_Znn_MF_SITE_DEFINED)this.get("MF_SITE_DEFINED");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_Znn_MF_SITE_DEFINED getMF_SITE_DEFINED(int rep) {
        MFN_Znn_MF_SITE_DEFINED ret = null;
        try {
            ret = (MFN_Znn_MF_SITE_DEFINED)this.get("MF_SITE_DEFINED", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getMF_SITE_DEFINEDReps() {
        int reps = -1;
        try {
            reps = this.getAll("MF_SITE_DEFINED").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<MFN_Znn_MF_SITE_DEFINED> getMF_SITE_DEFINEDAll() throws HL7Exception {
        return this.getAllAsList("MF_SITE_DEFINED", MFN_Znn_MF_SITE_DEFINED.class);
    }

    public void insertMF_SITE_DEFINED(MFN_Znn_MF_SITE_DEFINED structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_SITE_DEFINED", (Structure)structure, rep);
    }

    public MFN_Znn_MF_SITE_DEFINED insertMF_SITE_DEFINED(int rep) throws HL7Exception {
        return (MFN_Znn_MF_SITE_DEFINED)super.insertRepetition("MF_SITE_DEFINED", rep);
    }

    public MFN_Znn_MF_SITE_DEFINED removeMF_SITE_DEFINED(int rep) throws HL7Exception {
        return (MFN_Znn_MF_SITE_DEFINED)super.removeRepetition("MF_SITE_DEFINED", rep);
    }
}

