/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.NM;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.hl7v2.model.v25.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import org.slf4j.LoggerFactory;

public class ABS
extends AbstractSegment {
    public ABS(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(XCN.class, false, 1, 250, new Object[]{this.getMessage()}, "Discharge Care Provider");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Transfer Medical Service Code");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Severity of Illness Code");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date/Time of Attestation");
            this.add(XCN.class, false, 1, 250, new Object[]{this.getMessage()}, "Attested By");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Triage Code");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Abstract Completion Date/Time");
            this.add(XCN.class, false, 1, 250, new Object[]{this.getMessage()}, "Abstracted By");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Case Category Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Caesarian Section Indicator");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Gestation Category Code");
            this.add(NM.class, false, 1, 3, new Object[]{this.getMessage()}, "Gestation Period - Weeks");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Newborn Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Stillborn Indicator");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating ABS - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public XCN getDischargeCareProvider() {
        XCN ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getAbs1_DischargeCareProvider() {
        XCN ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getTransferMedicalServiceCode() {
        CE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getAbs2_TransferMedicalServiceCode() {
        CE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getSeverityOfIllnessCode() {
        CE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getAbs3_SeverityOfIllnessCode() {
        CE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getDateTimeOfAttestation() {
        TS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getAbs4_DateTimeOfAttestation() {
        TS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getAttestedBy() {
        XCN ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getAbs5_AttestedBy() {
        XCN ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getTriageCode() {
        CE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getAbs6_TriageCode() {
        CE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getAbstractCompletionDateTime() {
        TS ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getAbs7_AbstractCompletionDateTime() {
        TS ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getAbstractedBy() {
        XCN ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getAbs8_AbstractedBy() {
        XCN ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getCaseCategoryCode() {
        CE ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getAbs9_CaseCategoryCode() {
        CE ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getCaesarianSectionIndicator() {
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getAbs10_CaesarianSectionIndicator() {
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getGestationCategoryCode() {
        CE ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getAbs11_GestationCategoryCode() {
        CE ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getGestationPeriodWeeks() {
        NM ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getAbs12_GestationPeriodWeeks() {
        NM ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getNewbornCode() {
        CE ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getAbs13_NewbornCode() {
        CE ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getStillbornIndicator() {
        ID ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getAbs14_StillbornIndicator() {
        ID ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new XCN(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new TS(this.getMessage());
            }
            case 4: {
                return new XCN(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new XCN(this.getMessage());
            }
            case 8: {
                return new CE(this.getMessage());
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 10: {
                return new CE(this.getMessage());
            }
            case 11: {
                return new NM(this.getMessage());
            }
            case 12: {
                return new CE(this.getMessage());
            }
            case 13: {
                return new ID(this.getMessage(), new Integer(136));
            }
        }
        return null;
    }
}

