/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.CX;
import ca.uhn.hl7v2.model.v25.datatype.DLD;
import ca.uhn.hl7v2.model.v25.datatype.DT;
import ca.uhn.hl7v2.model.v25.datatype.FC;
import ca.uhn.hl7v2.model.v25.datatype.IS;
import ca.uhn.hl7v2.model.v25.datatype.NM;
import ca.uhn.hl7v2.model.v25.datatype.PL;
import ca.uhn.hl7v2.model.v25.datatype.SI;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.hl7v2.model.v25.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import org.slf4j.LoggerFactory;

public class PV1
extends AbstractSegment {
    public PV1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - PV1");
            this.add(IS.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(4)}, "Patient Class");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "Assigned Patient Location");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(7)}, "Admission Type");
            this.add(CX.class, false, 1, 250, new Object[]{this.getMessage()}, "Preadmit Number");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "Prior Patient Location");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Attending Doctor");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Referring Doctor");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Consulting Doctor");
            this.add(IS.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(69)}, "Hospital Service");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "Temporary Location");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(87)}, "Preadmit Test Indicator");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(92)}, "Re-admission Indicator");
            this.add(IS.class, false, 1, 6, new Object[]{this.getMessage(), new Integer(23)}, "Admit Source");
            this.add(IS.class, false, 0, 2, new Object[]{this.getMessage(), new Integer(9)}, "Ambulatory Status");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(99)}, "VIP Indicator");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Admitting Doctor");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(18)}, "Patient Type");
            this.add(CX.class, false, 1, 250, new Object[]{this.getMessage()}, "Visit Number");
            this.add(FC.class, false, 0, 50, new Object[]{this.getMessage()}, "Financial Class");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(32)}, "Charge Price Indicator");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(45)}, "Courtesy Code");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(46)}, "Credit Rating");
            this.add(IS.class, false, 0, 2, new Object[]{this.getMessage(), new Integer(44)}, "Contract Code");
            this.add(DT.class, false, 0, 8, new Object[]{this.getMessage()}, "Contract Effective Date");
            this.add(NM.class, false, 0, 12, new Object[]{this.getMessage()}, "Contract Amount");
            this.add(NM.class, false, 0, 3, new Object[]{this.getMessage()}, "Contract Period");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(73)}, "Interest Code");
            this.add(IS.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(110)}, "Transfer to Bad Debt Code");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Transfer to Bad Debt Date");
            this.add(IS.class, false, 1, 10, new Object[]{this.getMessage(), new Integer(21)}, "Bad Debt Agency Code");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Bad Debt Transfer Amount");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Bad Debt Recovery Amount");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(111)}, "Delete Account Indicator");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Delete Account Date");
            this.add(IS.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(112)}, "Discharge Disposition");
            this.add(DLD.class, false, 1, 47, new Object[]{this.getMessage()}, "Discharged to Location");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Diet Type");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(115)}, "Servicing Facility");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(116)}, "Bed Status");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(117)}, "Account Status");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "Pending Location");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage()}, "Prior Temporary Location");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Admit Date/Time");
            this.add(TS.class, false, 0, 26, new Object[]{this.getMessage()}, "Discharge Date/Time");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Current Patient Balance");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Total Charges");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Total Adjustments");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Total Payments");
            this.add(CX.class, false, 1, 250, new Object[]{this.getMessage()}, "Alternate Visit ID");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(326)}, "Visit Indicator");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Other Healthcare Provider");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating PV1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDPV1() {
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SI getPv11_SetIDPV1() {
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPatientClass() {
        IS ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPv12_PatientClass() {
        IS ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public PL getAssignedPatientLocation() {
        PL ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (PL)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public PL getPv13_AssignedPatientLocation() {
        PL ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (PL)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getAdmissionType() {
        IS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPv14_AdmissionType() {
        IS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getPreadmitNumber() {
        CX ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getPv15_PreadmitNumber() {
        CX ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public PL getPriorPatientLocation() {
        PL ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (PL)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public PL getPv16_PriorPatientLocation() {
        PL ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (PL)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN[] getAttendingDoctor() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(7);
            ret = new XCN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XCN)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getAttendingDoctorReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(7);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XCN getAttendingDoctor(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getPv17_AttendingDoctor(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPv17_AttendingDoctorReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(7);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XCN insertAttendingDoctor(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(7, rep);
    }

    public XCN insertPv17_AttendingDoctor(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(7, rep);
    }

    public XCN removeAttendingDoctor(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(7, rep);
    }

    public XCN removePv17_AttendingDoctor(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(7, rep);
    }

    public XCN[] getReferringDoctor() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(8);
            ret = new XCN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XCN)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getReferringDoctorReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(8);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XCN getReferringDoctor(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getPv18_ReferringDoctor(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPv18_ReferringDoctorReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(8);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XCN insertReferringDoctor(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(8, rep);
    }

    public XCN insertPv18_ReferringDoctor(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(8, rep);
    }

    public XCN removeReferringDoctor(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(8, rep);
    }

    public XCN removePv18_ReferringDoctor(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(8, rep);
    }

    public XCN[] getConsultingDoctor() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(9);
            ret = new XCN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XCN)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getConsultingDoctorReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(9);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XCN getConsultingDoctor(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getPv19_ConsultingDoctor(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPv19_ConsultingDoctorReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(9);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XCN insertConsultingDoctor(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(9, rep);
    }

    public XCN insertPv19_ConsultingDoctor(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(9, rep);
    }

    public XCN removeConsultingDoctor(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(9, rep);
    }

    public XCN removePv19_ConsultingDoctor(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(9, rep);
    }

    public IS getHospitalService() {
        IS ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPv110_HospitalService() {
        IS ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public PL getTemporaryLocation() {
        PL ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (PL)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public PL getPv111_TemporaryLocation() {
        PL ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (PL)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPreadmitTestIndicator() {
        IS ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPv112_PreadmitTestIndicator() {
        IS ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getReAdmissionIndicator() {
        IS ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPv113_ReAdmissionIndicator() {
        IS ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getAdmitSource() {
        IS ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPv114_AdmitSource() {
        IS ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS[] getAmbulatoryStatus() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(15);
            ret = new IS[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (IS)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getAmbulatoryStatusReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(15);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public IS getAmbulatoryStatus(int rep) {
        IS ret = null;
        try {
            Type t = this.getField(15, rep);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPv115_AmbulatoryStatus(int rep) {
        IS ret = null;
        try {
            Type t = this.getField(15, rep);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPv115_AmbulatoryStatusReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(15);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public IS insertAmbulatoryStatus(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(15, rep);
    }

    public IS insertPv115_AmbulatoryStatus(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(15, rep);
    }

    public IS removeAmbulatoryStatus(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(15, rep);
    }

    public IS removePv115_AmbulatoryStatus(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(15, rep);
    }

    public IS getVIPIndicator() {
        IS ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPv116_VIPIndicator() {
        IS ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN[] getAdmittingDoctor() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(17);
            ret = new XCN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XCN)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getAdmittingDoctorReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(17);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XCN getAdmittingDoctor(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(17, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getPv117_AdmittingDoctor(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(17, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPv117_AdmittingDoctorReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(17);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XCN insertAdmittingDoctor(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(17, rep);
    }

    public XCN insertPv117_AdmittingDoctor(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(17, rep);
    }

    public XCN removeAdmittingDoctor(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(17, rep);
    }

    public XCN removePv117_AdmittingDoctor(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(17, rep);
    }

    public IS getPatientType() {
        IS ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPv118_PatientType() {
        IS ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getVisitNumber() {
        CX ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getPv119_VisitNumber() {
        CX ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public FC[] getFinancialClass() {
        FC[] ret = null;
        try {
            Type[] t = this.getField(20);
            ret = new FC[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (FC)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getFinancialClassReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(20);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public FC getFinancialClass(int rep) {
        FC ret = null;
        try {
            Type t = this.getField(20, rep);
            ret = (FC)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public FC getPv120_FinancialClass(int rep) {
        FC ret = null;
        try {
            Type t = this.getField(20, rep);
            ret = (FC)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPv120_FinancialClassReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(20);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public FC insertFinancialClass(int rep) throws HL7Exception {
        return (FC)super.insertRepetition(20, rep);
    }

    public FC insertPv120_FinancialClass(int rep) throws HL7Exception {
        return (FC)super.insertRepetition(20, rep);
    }

    public FC removeFinancialClass(int rep) throws HL7Exception {
        return (FC)super.removeRepetition(20, rep);
    }

    public FC removePv120_FinancialClass(int rep) throws HL7Exception {
        return (FC)super.removeRepetition(20, rep);
    }

    public IS getChargePriceIndicator() {
        IS ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPv121_ChargePriceIndicator() {
        IS ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getCourtesyCode() {
        IS ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPv122_CourtesyCode() {
        IS ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getCreditRating() {
        IS ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPv123_CreditRating() {
        IS ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS[] getContractCode() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(24);
            ret = new IS[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (IS)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getContractCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(24);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public IS getContractCode(int rep) {
        IS ret = null;
        try {
            Type t = this.getField(24, rep);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPv124_ContractCode(int rep) {
        IS ret = null;
        try {
            Type t = this.getField(24, rep);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPv124_ContractCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(24);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public IS insertContractCode(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(24, rep);
    }

    public IS insertPv124_ContractCode(int rep) throws HL7Exception {
        return (IS)super.insertRepetition(24, rep);
    }

    public IS removeContractCode(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(24, rep);
    }

    public IS removePv124_ContractCode(int rep) throws HL7Exception {
        return (IS)super.removeRepetition(24, rep);
    }

    public DT[] getContractEffectiveDate() {
        DT[] ret = null;
        try {
            Type[] t = this.getField(25);
            ret = new DT[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (DT)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getContractEffectiveDateReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(25);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public DT getContractEffectiveDate(int rep) {
        DT ret = null;
        try {
            Type t = this.getField(25, rep);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getPv125_ContractEffectiveDate(int rep) {
        DT ret = null;
        try {
            Type t = this.getField(25, rep);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPv125_ContractEffectiveDateReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(25);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public DT insertContractEffectiveDate(int rep) throws HL7Exception {
        return (DT)super.insertRepetition(25, rep);
    }

    public DT insertPv125_ContractEffectiveDate(int rep) throws HL7Exception {
        return (DT)super.insertRepetition(25, rep);
    }

    public DT removeContractEffectiveDate(int rep) throws HL7Exception {
        return (DT)super.removeRepetition(25, rep);
    }

    public DT removePv125_ContractEffectiveDate(int rep) throws HL7Exception {
        return (DT)super.removeRepetition(25, rep);
    }

    public NM[] getContractAmount() {
        NM[] ret = null;
        try {
            Type[] t = this.getField(26);
            ret = new NM[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (NM)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getContractAmountReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(26);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public NM getContractAmount(int rep) {
        NM ret = null;
        try {
            Type t = this.getField(26, rep);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getPv126_ContractAmount(int rep) {
        NM ret = null;
        try {
            Type t = this.getField(26, rep);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPv126_ContractAmountReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(26);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public NM insertContractAmount(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(26, rep);
    }

    public NM insertPv126_ContractAmount(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(26, rep);
    }

    public NM removeContractAmount(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(26, rep);
    }

    public NM removePv126_ContractAmount(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(26, rep);
    }

    public NM[] getContractPeriod() {
        NM[] ret = null;
        try {
            Type[] t = this.getField(27);
            ret = new NM[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (NM)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getContractPeriodReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(27);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public NM getContractPeriod(int rep) {
        NM ret = null;
        try {
            Type t = this.getField(27, rep);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getPv127_ContractPeriod(int rep) {
        NM ret = null;
        try {
            Type t = this.getField(27, rep);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPv127_ContractPeriodReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(27);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public NM insertContractPeriod(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(27, rep);
    }

    public NM insertPv127_ContractPeriod(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(27, rep);
    }

    public NM removeContractPeriod(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(27, rep);
    }

    public NM removePv127_ContractPeriod(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(27, rep);
    }

    public IS getInterestCode() {
        IS ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPv128_InterestCode() {
        IS ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getTransferToBadDebtCode() {
        IS ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPv129_TransferToBadDebtCode() {
        IS ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getTransferToBadDebtDate() {
        DT ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getPv130_TransferToBadDebtDate() {
        DT ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getBadDebtAgencyCode() {
        IS ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPv131_BadDebtAgencyCode() {
        IS ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getBadDebtTransferAmount() {
        NM ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getPv132_BadDebtTransferAmount() {
        NM ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getBadDebtRecoveryAmount() {
        NM ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getPv133_BadDebtRecoveryAmount() {
        NM ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getDeleteAccountIndicator() {
        IS ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPv134_DeleteAccountIndicator() {
        IS ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getDeleteAccountDate() {
        DT ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DT getPv135_DeleteAccountDate() {
        DT ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (DT)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getDischargeDisposition() {
        IS ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPv136_DischargeDisposition() {
        IS ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DLD getDischargedToLocation() {
        DLD ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (DLD)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DLD getPv137_DischargedToLocation() {
        DLD ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (DLD)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getDietType() {
        CE ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getPv138_DietType() {
        CE ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getServicingFacility() {
        IS ret = null;
        try {
            Type t = this.getField(39, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPv139_ServicingFacility() {
        IS ret = null;
        try {
            Type t = this.getField(39, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getBedStatus() {
        IS ret = null;
        try {
            Type t = this.getField(40, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPv140_BedStatus() {
        IS ret = null;
        try {
            Type t = this.getField(40, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getAccountStatus() {
        IS ret = null;
        try {
            Type t = this.getField(41, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPv141_AccountStatus() {
        IS ret = null;
        try {
            Type t = this.getField(41, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public PL getPendingLocation() {
        PL ret = null;
        try {
            Type t = this.getField(42, 0);
            ret = (PL)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public PL getPv142_PendingLocation() {
        PL ret = null;
        try {
            Type t = this.getField(42, 0);
            ret = (PL)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public PL getPriorTemporaryLocation() {
        PL ret = null;
        try {
            Type t = this.getField(43, 0);
            ret = (PL)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public PL getPv143_PriorTemporaryLocation() {
        PL ret = null;
        try {
            Type t = this.getField(43, 0);
            ret = (PL)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getAdmitDateTime() {
        TS ret = null;
        try {
            Type t = this.getField(44, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getPv144_AdmitDateTime() {
        TS ret = null;
        try {
            Type t = this.getField(44, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS[] getDischargeDateTime() {
        TS[] ret = null;
        try {
            Type[] t = this.getField(45);
            ret = new TS[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (TS)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getDischargeDateTimeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(45);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public TS getDischargeDateTime(int rep) {
        TS ret = null;
        try {
            Type t = this.getField(45, rep);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getPv145_DischargeDateTime(int rep) {
        TS ret = null;
        try {
            Type t = this.getField(45, rep);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPv145_DischargeDateTimeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(45);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public TS insertDischargeDateTime(int rep) throws HL7Exception {
        return (TS)super.insertRepetition(45, rep);
    }

    public TS insertPv145_DischargeDateTime(int rep) throws HL7Exception {
        return (TS)super.insertRepetition(45, rep);
    }

    public TS removeDischargeDateTime(int rep) throws HL7Exception {
        return (TS)super.removeRepetition(45, rep);
    }

    public TS removePv145_DischargeDateTime(int rep) throws HL7Exception {
        return (TS)super.removeRepetition(45, rep);
    }

    public NM getCurrentPatientBalance() {
        NM ret = null;
        try {
            Type t = this.getField(46, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getPv146_CurrentPatientBalance() {
        NM ret = null;
        try {
            Type t = this.getField(46, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getTotalCharges() {
        NM ret = null;
        try {
            Type t = this.getField(47, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getPv147_TotalCharges() {
        NM ret = null;
        try {
            Type t = this.getField(47, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getTotalAdjustments() {
        NM ret = null;
        try {
            Type t = this.getField(48, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getPv148_TotalAdjustments() {
        NM ret = null;
        try {
            Type t = this.getField(48, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getTotalPayments() {
        NM ret = null;
        try {
            Type t = this.getField(49, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getPv149_TotalPayments() {
        NM ret = null;
        try {
            Type t = this.getField(49, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getAlternateVisitID() {
        CX ret = null;
        try {
            Type t = this.getField(50, 0);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getPv150_AlternateVisitID() {
        CX ret = null;
        try {
            Type t = this.getField(50, 0);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getVisitIndicator() {
        IS ret = null;
        try {
            Type t = this.getField(51, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPv151_VisitIndicator() {
        IS ret = null;
        try {
            Type t = this.getField(51, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN[] getOtherHealthcareProvider() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(52);
            ret = new XCN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XCN)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getOtherHealthcareProviderReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(52);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XCN getOtherHealthcareProvider(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(52, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getPv152_OtherHealthcareProvider(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(52, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPv152_OtherHealthcareProviderReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(52);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public XCN insertOtherHealthcareProvider(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(52, rep);
    }

    public XCN insertPv152_OtherHealthcareProvider(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(52, rep);
    }

    public XCN removeOtherHealthcareProvider(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(52, rep);
    }

    public XCN removePv152_OtherHealthcareProvider(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(52, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new IS(this.getMessage(), new Integer(4));
            }
            case 2: {
                return new PL(this.getMessage());
            }
            case 3: {
                return new IS(this.getMessage(), new Integer(7));
            }
            case 4: {
                return new CX(this.getMessage());
            }
            case 5: {
                return new PL(this.getMessage());
            }
            case 6: {
                return new XCN(this.getMessage());
            }
            case 7: {
                return new XCN(this.getMessage());
            }
            case 8: {
                return new XCN(this.getMessage());
            }
            case 9: {
                return new IS(this.getMessage(), new Integer(69));
            }
            case 10: {
                return new PL(this.getMessage());
            }
            case 11: {
                return new IS(this.getMessage(), new Integer(87));
            }
            case 12: {
                return new IS(this.getMessage(), new Integer(92));
            }
            case 13: {
                return new IS(this.getMessage(), new Integer(23));
            }
            case 14: {
                return new IS(this.getMessage(), new Integer(9));
            }
            case 15: {
                return new IS(this.getMessage(), new Integer(99));
            }
            case 16: {
                return new XCN(this.getMessage());
            }
            case 17: {
                return new IS(this.getMessage(), new Integer(18));
            }
            case 18: {
                return new CX(this.getMessage());
            }
            case 19: {
                return new FC(this.getMessage());
            }
            case 20: {
                return new IS(this.getMessage(), new Integer(32));
            }
            case 21: {
                return new IS(this.getMessage(), new Integer(45));
            }
            case 22: {
                return new IS(this.getMessage(), new Integer(46));
            }
            case 23: {
                return new IS(this.getMessage(), new Integer(44));
            }
            case 24: {
                return new DT(this.getMessage());
            }
            case 25: {
                return new NM(this.getMessage());
            }
            case 26: {
                return new NM(this.getMessage());
            }
            case 27: {
                return new IS(this.getMessage(), new Integer(73));
            }
            case 28: {
                return new IS(this.getMessage(), new Integer(110));
            }
            case 29: {
                return new DT(this.getMessage());
            }
            case 30: {
                return new IS(this.getMessage(), new Integer(21));
            }
            case 31: {
                return new NM(this.getMessage());
            }
            case 32: {
                return new NM(this.getMessage());
            }
            case 33: {
                return new IS(this.getMessage(), new Integer(111));
            }
            case 34: {
                return new DT(this.getMessage());
            }
            case 35: {
                return new IS(this.getMessage(), new Integer(112));
            }
            case 36: {
                return new DLD(this.getMessage());
            }
            case 37: {
                return new CE(this.getMessage());
            }
            case 38: {
                return new IS(this.getMessage(), new Integer(115));
            }
            case 39: {
                return new IS(this.getMessage(), new Integer(116));
            }
            case 40: {
                return new IS(this.getMessage(), new Integer(117));
            }
            case 41: {
                return new PL(this.getMessage());
            }
            case 42: {
                return new PL(this.getMessage());
            }
            case 43: {
                return new TS(this.getMessage());
            }
            case 44: {
                return new TS(this.getMessage());
            }
            case 45: {
                return new NM(this.getMessage());
            }
            case 46: {
                return new NM(this.getMessage());
            }
            case 47: {
                return new NM(this.getMessage());
            }
            case 48: {
                return new NM(this.getMessage());
            }
            case 49: {
                return new CX(this.getMessage());
            }
            case 50: {
                return new IS(this.getMessage(), new Integer(326));
            }
            case 51: {
                return new XCN(this.getMessage());
            }
        }
        return null;
    }
}

