/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.OUL_R23_ORDER;
import ca.uhn.hl7v2.model.v25.segment.INV;
import ca.uhn.hl7v2.model.v25.segment.SAC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OUL_R23_CONTAINER
extends AbstractGroup {
    public OUL_R23_CONTAINER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SAC.class, true, false, false);
            this.add(INV.class, false, false, false);
            this.add(OUL_R23_ORDER.class, true, true, false);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating OUL_R23_CONTAINER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public SAC getSAC() {
        SAC retVal = (SAC)this.getTyped("SAC", SAC.class);
        return retVal;
    }

    public INV getINV() {
        INV retVal = (INV)this.getTyped("INV", INV.class);
        return retVal;
    }

    public OUL_R23_ORDER getORDER() {
        OUL_R23_ORDER retVal = (OUL_R23_ORDER)this.getTyped("ORDER", OUL_R23_ORDER.class);
        return retVal;
    }

    public OUL_R23_ORDER getORDER(int rep) {
        OUL_R23_ORDER retVal = (OUL_R23_ORDER)this.getTyped("ORDER", rep, OUL_R23_ORDER.class);
        return retVal;
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<OUL_R23_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", OUL_R23_ORDER.class);
    }

    public void insertORDER(OUL_R23_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", (Structure)structure, rep);
    }

    public OUL_R23_ORDER insertORDER(int rep) throws HL7Exception {
        return (OUL_R23_ORDER)super.insertRepetition("ORDER", rep);
    }

    public OUL_R23_ORDER removeORDER(int rep) throws HL7Exception {
        return (OUL_R23_ORDER)super.removeRepetition("ORDER", rep);
    }
}

