/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.MFN_M12_MF_OBS_ATTRIBUTES;
import ca.uhn.hl7v2.model.v25.segment.MFI;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.model.v25.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFN_M12
extends AbstractMessage {
    public MFN_M12() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public MFN_M12(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(MFI.class, true, false);
            this.add(MFN_M12_MF_OBS_ATTRIBUTES.class, true, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating MFN_M12 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public MFI getMFI() {
        return (MFI)this.getTyped("MFI", MFI.class);
    }

    public MFN_M12_MF_OBS_ATTRIBUTES getMF_OBS_ATTRIBUTES() {
        return (MFN_M12_MF_OBS_ATTRIBUTES)this.getTyped("MF_OBS_ATTRIBUTES", MFN_M12_MF_OBS_ATTRIBUTES.class);
    }

    public MFN_M12_MF_OBS_ATTRIBUTES getMF_OBS_ATTRIBUTES(int rep) {
        return (MFN_M12_MF_OBS_ATTRIBUTES)this.getTyped("MF_OBS_ATTRIBUTES", rep, MFN_M12_MF_OBS_ATTRIBUTES.class);
    }

    public int getMF_OBS_ATTRIBUTESReps() {
        return this.getReps("MF_OBS_ATTRIBUTES");
    }

    public List<MFN_M12_MF_OBS_ATTRIBUTES> getMF_OBS_ATTRIBUTESAll() throws HL7Exception {
        return this.getAllAsList("MF_OBS_ATTRIBUTES", MFN_M12_MF_OBS_ATTRIBUTES.class);
    }

    public void insertMF_OBS_ATTRIBUTES(MFN_M12_MF_OBS_ATTRIBUTES structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_OBS_ATTRIBUTES", (Structure)structure, rep);
    }

    public MFN_M12_MF_OBS_ATTRIBUTES insertMF_OBS_ATTRIBUTES(int rep) throws HL7Exception {
        return (MFN_M12_MF_OBS_ATTRIBUTES)super.insertRepetition("MF_OBS_ATTRIBUTES", rep);
    }

    public MFN_M12_MF_OBS_ATTRIBUTES removeMF_OBS_ATTRIBUTES(int rep) throws HL7Exception {
        return (MFN_M12_MF_OBS_ATTRIBUTES)super.removeRepetition("MF_OBS_ATTRIBUTES", rep);
    }
}

