/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.RRA_O18_ADMINISTRATION;
import ca.uhn.hl7v2.model.v25.group.RRA_O18_TIMING;
import ca.uhn.hl7v2.model.v25.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RRA_O18_ORDER
extends AbstractGroup {
    public RRA_O18_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(RRA_O18_TIMING.class, false, true, false);
            this.add(RRA_O18_ADMINISTRATION.class, false, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RRA_O18_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public RRA_O18_TIMING getTIMING() {
        RRA_O18_TIMING retVal = (RRA_O18_TIMING)this.getTyped("TIMING", RRA_O18_TIMING.class);
        return retVal;
    }

    public RRA_O18_TIMING getTIMING(int rep) {
        RRA_O18_TIMING retVal = (RRA_O18_TIMING)this.getTyped("TIMING", rep, RRA_O18_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<RRA_O18_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", RRA_O18_TIMING.class);
    }

    public void insertTIMING(RRA_O18_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public RRA_O18_TIMING insertTIMING(int rep) throws HL7Exception {
        return (RRA_O18_TIMING)super.insertRepetition("TIMING", rep);
    }

    public RRA_O18_TIMING removeTIMING(int rep) throws HL7Exception {
        return (RRA_O18_TIMING)super.removeRepetition("TIMING", rep);
    }

    public RRA_O18_ADMINISTRATION getADMINISTRATION() {
        RRA_O18_ADMINISTRATION retVal = (RRA_O18_ADMINISTRATION)this.getTyped("ADMINISTRATION", RRA_O18_ADMINISTRATION.class);
        return retVal;
    }
}

