/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v251.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 PRL (Parent Result Link) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Parent Observation Identifier (CE)
 * <li>Parent Observation Sub-identifier (ST)
 * <li>Parent Observation Value Descriptor (TX)
 * </ul>
 */
public class PRL extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new PRL type
     */
    public PRL(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[3];    
        data[0] = new CE(getMessage());
        data[1] = new ST(getMessage());
        data[2] = new TX(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Parent Observation Identifier (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getParentObservationIdentifier() {
       CE ret = null;
       try {
          ret = (CE)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Parent Observation Identifier (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getPrl1_ParentObservationIdentifier() {
       CE ret = null;
       try {
          ret = (CE)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Parent Observation Sub-identifier (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getParentObservationSubIdentifier() {
       ST ret = null;
       try {
          ret = (ST)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Parent Observation Sub-identifier (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getPrl2_ParentObservationSubIdentifier() {
       ST ret = null;
       try {
          ret = (ST)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Parent Observation Value Descriptor (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TX getParentObservationValueDescriptor() {
       TX ret = null;
       try {
          ret = (TX)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Parent Observation Value Descriptor (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TX getPrl3_ParentObservationValueDescriptor() {
       TX ret = null;
       try {
          ret = (TX)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

