/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.model.v251.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a OML_O35_PRIOR_RESULT group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: OML_O35_PATIENT_PRIOR (a Group object) <b>optional </b></li>
                 * <li>2: OML_O35_PATIENT_VISIT_PRIOR (a Group object) <b>optional </b></li>
                 * <li>3: AL1 (Patient Allergy Information) <b>optional repeating</b></li>
                 * <li>4: OML_O35_ORDER_PRIOR (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class OML_O35_PRIOR_RESULT extends AbstractGroup {

    /** 
     * Creates a new OML_O35_PRIOR_RESULT group
     */
    public OML_O35_PRIOR_RESULT(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(OML_O35_PATIENT_PRIOR.class, false, false);
                          this.add(OML_O35_PATIENT_VISIT_PRIOR.class, false, false);
                          this.add(AL1.class, false, true);
                          this.add(OML_O35_ORDER_PRIOR.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating OML_O35_PRIOR_RESULT - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.5.1"
     */
    public String getVersion() {
       return "2.5.1";
    }



    /**
     * Returns
     * PATIENT_PRIOR (a Group object) - creates it if necessary
     */
    public OML_O35_PATIENT_PRIOR getPATIENT_PRIOR() { 
       OML_O35_PATIENT_PRIOR ret = null;
       try {
          ret = (OML_O35_PATIENT_PRIOR)this.get("PATIENT_PRIOR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * PATIENT_VISIT_PRIOR (a Group object) - creates it if necessary
     */
    public OML_O35_PATIENT_VISIT_PRIOR getPATIENT_VISIT_PRIOR() { 
       OML_O35_PATIENT_VISIT_PRIOR ret = null;
       try {
          ret = (OML_O35_PATIENT_VISIT_PRIOR)this.get("PATIENT_VISIT_PRIOR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * AL1 (Patient Allergy Information) - creates it if necessary
     */
    public AL1 getAL1() { 
       AL1 ret = null;
       try {
          ret = (AL1)this.get("AL1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * AL1 (Patient Allergy Information) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public AL1 getAL1(int rep) { 
       AL1 ret = null;
       try {
          ret = (AL1)this.get("AL1", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of AL1 
     */ 
    public int getAL1Reps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("AL1").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of AL1 (Patient Allergy Information)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertAL1(AL1 structure, int rep) throws HL7Exception { 
       super.insertRepetition("AL1", structure, rep);
    }


    /**
     * Inserts a specific repetition of AL1 (Patient Allergy Information)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public AL1 insertAL1(int rep) throws HL7Exception { 
       return (AL1)super.insertRepetition("AL1", rep);
    }


    /**
     * Removes a specific repetition of AL1 (Patient Allergy Information)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public AL1 removeAL1(int rep) throws HL7Exception { 
       return (AL1)super.removeRepetition("AL1", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * ORDER_PRIOR (a Group object) - creates it if necessary
     */
    public OML_O35_ORDER_PRIOR getORDER_PRIOR() { 
       OML_O35_ORDER_PRIOR ret = null;
       try {
          ret = (OML_O35_ORDER_PRIOR)this.get("ORDER_PRIOR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORDER_PRIOR (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public OML_O35_ORDER_PRIOR getORDER_PRIOR(int rep) { 
       OML_O35_ORDER_PRIOR ret = null;
       try {
          ret = (OML_O35_ORDER_PRIOR)this.get("ORDER_PRIOR", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORDER_PRIOR 
     */ 
    public int getORDER_PRIORReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORDER_PRIOR").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORDER_PRIOR (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertORDER_PRIOR(OML_O35_ORDER_PRIOR structure, int rep) throws HL7Exception { 
       super.insertRepetition("ORDER_PRIOR", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORDER_PRIOR (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public OML_O35_ORDER_PRIOR insertORDER_PRIOR(int rep) throws HL7Exception { 
       return (OML_O35_ORDER_PRIOR)super.insertRepetition("ORDER_PRIOR", rep);
    }


    /**
     * Removes a specific repetition of ORDER_PRIOR (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public OML_O35_ORDER_PRIOR removeORDER_PRIOR(int rep) throws HL7Exception { 
       return (OML_O35_ORDER_PRIOR)super.removeRepetition("ORDER_PRIOR", rep);
    }



}

