/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v251.segment;

// import ca.uhn.hl7v2.model.v251.group.*;
import ca.uhn.hl7v2.model.v251.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 CDM message segment (Charge Description Master). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>CDM-1: Primary Key Value - CDM (CE) <b> </b>
     * <li>CDM-2: Charge Code Alias (CE) <b>optional repeating</b>
     * <li>CDM-3: Charge Description Short (ST) <b> </b>
     * <li>CDM-4: Charge Description Long (ST) <b>optional </b>
     * <li>CDM-5: Description Override Indicator (IS) <b>optional </b>
     * <li>CDM-6: Exploding Charges (CE) <b>optional repeating</b>
     * <li>CDM-7: Procedure Code (CE) <b>optional repeating</b>
     * <li>CDM-8: Active/Inactive Flag (ID) <b>optional </b>
     * <li>CDM-9: Inventory Number (CE) <b>optional repeating</b>
     * <li>CDM-10: Resource Load (NM) <b>optional </b>
     * <li>CDM-11: Contract Number (CX) <b>optional repeating</b>
     * <li>CDM-12: Contract Organization (XON) <b>optional repeating</b>
     * <li>CDM-13: Room Fee Indicator (ID) <b>optional </b>
 * </ul>
 */
public class CDM extends AbstractSegment {

    /** 
     * Creates a new CDM segment
     */
    public CDM(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(CE.class, true, 1, 250, new Object[]{ getMessage(), new Integer(132) }, "Primary Key Value - CDM");
                                  this.add(CE.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Charge Code Alias");
                                  this.add(ST.class, true, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Charge Description Short");
                                  this.add(ST.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Charge Description Long");
                                  this.add(IS.class, false, 1, 1, new Object[]{ getMessage() }, "Description Override Indicator");
                                  this.add(CE.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Exploding Charges");
                                  this.add(CE.class, false, 0, 250, new Object[]{ getMessage(), new Integer(88) }, "Procedure Code");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Active/Inactive Flag");
                                  this.add(CE.class, false, 0, 250, new Object[]{ getMessage(), new Integer(463) }, "Inventory Number");
                                  this.add(NM.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Resource Load");
                                  this.add(CX.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Contract Number");
                                  this.add(XON.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Contract Organization");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Room Fee Indicator");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating CDM - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * CDM-1: "Primary Key Value - CDM" - creates it if necessary
     */
    public CE getPrimaryKeyValueCDM() { 
        CE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * CDM-1: "Primary Key Value - CDM" - creates it if necessary
     */
    public CE getCdm1_PrimaryKeyValueCDM() { 
        CE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Charge Code Alias (CDM-2).
     */
    public CE[] getChargeCodeAlias() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(2);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * CDM-2: "Charge Code Alias" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getChargeCodeAlias(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * CDM-2: "Charge Code Alias" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getCdm2_ChargeCodeAlias(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * CDM-2: "Charge Code Alias" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertChargeCodeAlias(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(2, rep);
    }



    /**
     * Inserts a repetition of
     * CDM-2: "Charge Code Alias" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertCdm2_ChargeCodeAlias(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * CDM-2: "Charge Code Alias" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeChargeCodeAlias(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * CDM-2: "Charge Code Alias" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeCdm2_ChargeCodeAlias(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(2, rep);
    }




    /**
     * Returns
     * CDM-3: "Charge Description Short" - creates it if necessary
     */
    public ST getChargeDescriptionShort() { 
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * CDM-3: "Charge Description Short" - creates it if necessary
     */
    public ST getCdm3_ChargeDescriptionShort() { 
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * CDM-4: "Charge Description Long" - creates it if necessary
     */
    public ST getChargeDescriptionLong() { 
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * CDM-4: "Charge Description Long" - creates it if necessary
     */
    public ST getCdm4_ChargeDescriptionLong() { 
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * CDM-5: "Description Override Indicator" - creates it if necessary
     */
    public IS getDescriptionOverrideIndicator() { 
        IS ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * CDM-5: "Description Override Indicator" - creates it if necessary
     */
    public IS getCdm5_DescriptionOverrideIndicator() { 
        IS ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Exploding Charges (CDM-6).
     */
    public CE[] getExplodingCharges() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(6);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * CDM-6: "Exploding Charges" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getExplodingCharges(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * CDM-6: "Exploding Charges" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getCdm6_ExplodingCharges(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * CDM-6: "Exploding Charges" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertExplodingCharges(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(6, rep);
    }



    /**
     * Inserts a repetition of
     * CDM-6: "Exploding Charges" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertCdm6_ExplodingCharges(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * CDM-6: "Exploding Charges" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeExplodingCharges(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * CDM-6: "Exploding Charges" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeCdm6_ExplodingCharges(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(6, rep);
    }



    /**
     * Returns all repetitions of Procedure Code (CDM-7).
     */
    public CE[] getProcedureCode() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(7);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * CDM-7: "Procedure Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getProcedureCode(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * CDM-7: "Procedure Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getCdm7_ProcedureCode(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * CDM-7: "Procedure Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertProcedureCode(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(7, rep);
    }



    /**
     * Inserts a repetition of
     * CDM-7: "Procedure Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertCdm7_ProcedureCode(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * CDM-7: "Procedure Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeProcedureCode(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * CDM-7: "Procedure Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeCdm7_ProcedureCode(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(7, rep);
    }




    /**
     * Returns
     * CDM-8: "Active/Inactive Flag" - creates it if necessary
     */
    public ID getActiveInactiveFlag() { 
        ID ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * CDM-8: "Active/Inactive Flag" - creates it if necessary
     */
    public ID getCdm8_ActiveInactiveFlag() { 
        ID ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Inventory Number (CDM-9).
     */
    public CE[] getInventoryNumber() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(9);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * CDM-9: "Inventory Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getInventoryNumber(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * CDM-9: "Inventory Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getCdm9_InventoryNumber(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * CDM-9: "Inventory Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertInventoryNumber(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(9, rep);
    }



    /**
     * Inserts a repetition of
     * CDM-9: "Inventory Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertCdm9_InventoryNumber(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(9, rep);
    }


    /**
     * Removes a repetition of
     * CDM-9: "Inventory Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeInventoryNumber(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(9, rep);
    }


    /**
     * Removes a repetition of
     * CDM-9: "Inventory Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeCdm9_InventoryNumber(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(9, rep);
    }




    /**
     * Returns
     * CDM-10: "Resource Load" - creates it if necessary
     */
    public NM getResourceLoad() { 
        NM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * CDM-10: "Resource Load" - creates it if necessary
     */
    public NM getCdm10_ResourceLoad() { 
        NM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Contract Number (CDM-11).
     */
    public CX[] getContractNumber() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(11);  
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CX)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * CDM-11: "Contract Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getContractNumber(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * CDM-11: "Contract Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getCdm11_ContractNumber(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * CDM-11: "Contract Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertContractNumber(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(11, rep);
    }



    /**
     * Inserts a repetition of
     * CDM-11: "Contract Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertCdm11_ContractNumber(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(11, rep);
    }


    /**
     * Removes a repetition of
     * CDM-11: "Contract Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removeContractNumber(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(11, rep);
    }


    /**
     * Removes a repetition of
     * CDM-11: "Contract Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removeCdm11_ContractNumber(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(11, rep);
    }



    /**
     * Returns all repetitions of Contract Organization (CDM-12).
     */
    public XON[] getContractOrganization() {
        XON[] ret = null;
        try {
            Type[] t = this.getField(12);  
            ret = new XON[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XON)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * CDM-12: "Contract Organization" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XON getContractOrganization(int rep) { 
        XON ret = null;
        try {
            Type t = this.getField(12, rep);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * CDM-12: "Contract Organization" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XON getCdm12_ContractOrganization(int rep) { 
        XON ret = null;
        try {
            Type t = this.getField(12, rep);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * CDM-12: "Contract Organization" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON insertContractOrganization(int rep) throws HL7Exception { 
        return (XON) super.insertRepetition(12, rep);
    }



    /**
     * Inserts a repetition of
     * CDM-12: "Contract Organization" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON insertCdm12_ContractOrganization(int rep) throws HL7Exception { 
        return (XON) super.insertRepetition(12, rep);
    }


    /**
     * Removes a repetition of
     * CDM-12: "Contract Organization" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON removeContractOrganization(int rep) throws HL7Exception { 
        return (XON) super.removeRepetition(12, rep);
    }


    /**
     * Removes a repetition of
     * CDM-12: "Contract Organization" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON removeCdm12_ContractOrganization(int rep) throws HL7Exception { 
        return (XON) super.removeRepetition(12, rep);
    }




    /**
     * Returns
     * CDM-13: "Room Fee Indicator" - creates it if necessary
     */
    public ID getRoomFeeIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * CDM-13: "Room Fee Indicator" - creates it if necessary
     */
    public ID getCdm13_RoomFeeIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new CE(getMessage());
          case 1: return new CE(getMessage());
          case 2: return new ST(getMessage());
          case 3: return new ST(getMessage());
          case 4: return new IS(getMessage(), new Integer( 268 ));
          case 5: return new CE(getMessage());
          case 6: return new CE(getMessage());
          case 7: return new ID(getMessage(), new Integer( 183 ));
          case 8: return new CE(getMessage());
          case 9: return new NM(getMessage());
          case 10: return new CX(getMessage());
          case 11: return new XON(getMessage());
          case 12: return new ID(getMessage(), new Integer( 136 ));
          default: return null;
       }
   }


}

