/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v251.segment;

// import ca.uhn.hl7v2.model.v251.group.*;
import ca.uhn.hl7v2.model.v251.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 GOL message segment (Goal Detail). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>GOL-1: Action Code (ID) <b> </b>
     * <li>GOL-2: Action Date/Time (TS) <b> </b>
     * <li>GOL-3: Goal ID (CE) <b> </b>
     * <li>GOL-4: Goal Instance ID (EI) <b> </b>
     * <li>GOL-5: Episode of Care ID (EI) <b>optional </b>
     * <li>GOL-6: Goal List Priority (NM) <b>optional </b>
     * <li>GOL-7: Goal Established Date/Time (TS) <b>optional </b>
     * <li>GOL-8: Expected Goal Achieve Date/Time (TS) <b>optional </b>
     * <li>GOL-9: Goal Classification (CE) <b>optional </b>
     * <li>GOL-10: Goal Management Discipline (CE) <b>optional </b>
     * <li>GOL-11: Current Goal Review Status (CE) <b>optional </b>
     * <li>GOL-12: Current Goal Review Date/Time (TS) <b>optional </b>
     * <li>GOL-13: Next Goal Review Date/Time (TS) <b>optional </b>
     * <li>GOL-14: Previous Goal Review Date/Time (TS) <b>optional </b>
     * <li>GOL-15: Goal Review Interval (TQ) <b>optional </b>
     * <li>GOL-16: Goal Evaluation (CE) <b>optional </b>
     * <li>GOL-17: Goal Evaluation Comment (ST) <b>optional repeating</b>
     * <li>GOL-18: Goal Life Cycle Status (CE) <b>optional </b>
     * <li>GOL-19: Goal Life Cycle Status Date/Time (TS) <b>optional </b>
     * <li>GOL-20: Goal Target Type (CE) <b>optional repeating</b>
     * <li>GOL-21: Goal Target Name (XPN) <b>optional repeating</b>
 * </ul>
 */
public class GOL extends AbstractSegment {

    /** 
     * Creates a new GOL segment
     */
    public GOL(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(ID.class, true, 1, 2, new Object[]{ getMessage() }, "Action Code");
                                  this.add(TS.class, true, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Action Date/Time");
                                  this.add(CE.class, true, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Goal ID");
                                  this.add(EI.class, true, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Goal Instance ID");
                                  this.add(EI.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Episode of Care ID");
                                  this.add(NM.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Goal List Priority");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Goal Established Date/Time");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Expected Goal Achieve Date/Time");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Goal Classification");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Goal Management Discipline");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Current Goal Review Status");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Current Goal Review Date/Time");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Next Goal Review Date/Time");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Previous Goal Review Date/Time");
                                  this.add(TQ.class, false, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "Goal Review Interval");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Goal Evaluation");
                                  this.add(ST.class, false, 0, 300, new Object[]{ getMessage(), new Integer(0) }, "Goal Evaluation Comment");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Goal Life Cycle Status");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Goal Life Cycle Status Date/Time");
                                  this.add(CE.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Goal Target Type");
                                  this.add(XPN.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Goal Target Name");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating GOL - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * GOL-1: "Action Code" - creates it if necessary
     */
    public ID getActionCode() { 
        ID ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GOL-1: "Action Code" - creates it if necessary
     */
    public ID getGol1_ActionCode() { 
        ID ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GOL-2: "Action Date/Time" - creates it if necessary
     */
    public TS getActionDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GOL-2: "Action Date/Time" - creates it if necessary
     */
    public TS getGol2_ActionDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GOL-3: "Goal ID" - creates it if necessary
     */
    public CE getGoalID() { 
        CE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GOL-3: "Goal ID" - creates it if necessary
     */
    public CE getGol3_GoalID() { 
        CE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GOL-4: "Goal Instance ID" - creates it if necessary
     */
    public EI getGoalInstanceID() { 
        EI ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GOL-4: "Goal Instance ID" - creates it if necessary
     */
    public EI getGol4_GoalInstanceID() { 
        EI ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GOL-5: "Episode of Care ID" - creates it if necessary
     */
    public EI getEpisodeOfCareID() { 
        EI ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GOL-5: "Episode of Care ID" - creates it if necessary
     */
    public EI getGol5_EpisodeOfCareID() { 
        EI ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GOL-6: "Goal List Priority" - creates it if necessary
     */
    public NM getGoalListPriority() { 
        NM ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GOL-6: "Goal List Priority" - creates it if necessary
     */
    public NM getGol6_GoalListPriority() { 
        NM ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GOL-7: "Goal Established Date/Time" - creates it if necessary
     */
    public TS getGoalEstablishedDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GOL-7: "Goal Established Date/Time" - creates it if necessary
     */
    public TS getGol7_GoalEstablishedDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GOL-8: "Expected Goal Achieve Date/Time" - creates it if necessary
     */
    public TS getExpectedGoalAchieveDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GOL-8: "Expected Goal Achieve Date/Time" - creates it if necessary
     */
    public TS getGol8_ExpectedGoalAchieveDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GOL-9: "Goal Classification" - creates it if necessary
     */
    public CE getGoalClassification() { 
        CE ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GOL-9: "Goal Classification" - creates it if necessary
     */
    public CE getGol9_GoalClassification() { 
        CE ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GOL-10: "Goal Management Discipline" - creates it if necessary
     */
    public CE getGoalManagementDiscipline() { 
        CE ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GOL-10: "Goal Management Discipline" - creates it if necessary
     */
    public CE getGol10_GoalManagementDiscipline() { 
        CE ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GOL-11: "Current Goal Review Status" - creates it if necessary
     */
    public CE getCurrentGoalReviewStatus() { 
        CE ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GOL-11: "Current Goal Review Status" - creates it if necessary
     */
    public CE getGol11_CurrentGoalReviewStatus() { 
        CE ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GOL-12: "Current Goal Review Date/Time" - creates it if necessary
     */
    public TS getCurrentGoalReviewDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GOL-12: "Current Goal Review Date/Time" - creates it if necessary
     */
    public TS getGol12_CurrentGoalReviewDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GOL-13: "Next Goal Review Date/Time" - creates it if necessary
     */
    public TS getNextGoalReviewDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GOL-13: "Next Goal Review Date/Time" - creates it if necessary
     */
    public TS getGol13_NextGoalReviewDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GOL-14: "Previous Goal Review Date/Time" - creates it if necessary
     */
    public TS getPreviousGoalReviewDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GOL-14: "Previous Goal Review Date/Time" - creates it if necessary
     */
    public TS getGol14_PreviousGoalReviewDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GOL-15: "Goal Review Interval" - creates it if necessary
     */
    public TQ getGoalReviewInterval() { 
        TQ ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (TQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GOL-15: "Goal Review Interval" - creates it if necessary
     */
    public TQ getGol15_GoalReviewInterval() { 
        TQ ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (TQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GOL-16: "Goal Evaluation" - creates it if necessary
     */
    public CE getGoalEvaluation() { 
        CE ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GOL-16: "Goal Evaluation" - creates it if necessary
     */
    public CE getGol16_GoalEvaluation() { 
        CE ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Goal Evaluation Comment (GOL-17).
     */
    public ST[] getGoalEvaluationComment() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(17);  
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ST)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GOL-17: "Goal Evaluation Comment" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getGoalEvaluationComment(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(17, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GOL-17: "Goal Evaluation Comment" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getGol17_GoalEvaluationComment(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(17, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * GOL-17: "Goal Evaluation Comment" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertGoalEvaluationComment(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(17, rep);
    }



    /**
     * Inserts a repetition of
     * GOL-17: "Goal Evaluation Comment" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertGol17_GoalEvaluationComment(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(17, rep);
    }


    /**
     * Removes a repetition of
     * GOL-17: "Goal Evaluation Comment" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeGoalEvaluationComment(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(17, rep);
    }


    /**
     * Removes a repetition of
     * GOL-17: "Goal Evaluation Comment" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeGol17_GoalEvaluationComment(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(17, rep);
    }




    /**
     * Returns
     * GOL-18: "Goal Life Cycle Status" - creates it if necessary
     */
    public CE getGoalLifeCycleStatus() { 
        CE ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GOL-18: "Goal Life Cycle Status" - creates it if necessary
     */
    public CE getGol18_GoalLifeCycleStatus() { 
        CE ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GOL-19: "Goal Life Cycle Status Date/Time" - creates it if necessary
     */
    public TS getGoalLifeCycleStatusDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GOL-19: "Goal Life Cycle Status Date/Time" - creates it if necessary
     */
    public TS getGol19_GoalLifeCycleStatusDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Goal Target Type (GOL-20).
     */
    public CE[] getGoalTargetType() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(20);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GOL-20: "Goal Target Type" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getGoalTargetType(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(20, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GOL-20: "Goal Target Type" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getGol20_GoalTargetType(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(20, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * GOL-20: "Goal Target Type" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertGoalTargetType(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(20, rep);
    }



    /**
     * Inserts a repetition of
     * GOL-20: "Goal Target Type" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertGol20_GoalTargetType(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(20, rep);
    }


    /**
     * Removes a repetition of
     * GOL-20: "Goal Target Type" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeGoalTargetType(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(20, rep);
    }


    /**
     * Removes a repetition of
     * GOL-20: "Goal Target Type" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeGol20_GoalTargetType(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(20, rep);
    }



    /**
     * Returns all repetitions of Goal Target Name (GOL-21).
     */
    public XPN[] getGoalTargetName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(21);  
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XPN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GOL-21: "Goal Target Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getGoalTargetName(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(21, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GOL-21: "Goal Target Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getGol21_GoalTargetName(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(21, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * GOL-21: "Goal Target Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertGoalTargetName(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(21, rep);
    }



    /**
     * Inserts a repetition of
     * GOL-21: "Goal Target Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertGol21_GoalTargetName(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(21, rep);
    }


    /**
     * Removes a repetition of
     * GOL-21: "Goal Target Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removeGoalTargetName(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(21, rep);
    }


    /**
     * Removes a repetition of
     * GOL-21: "Goal Target Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removeGol21_GoalTargetName(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(21, rep);
    }






    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new ID(getMessage(), new Integer( 287 ));
          case 1: return new TS(getMessage());
          case 2: return new CE(getMessage());
          case 3: return new EI(getMessage());
          case 4: return new EI(getMessage());
          case 5: return new NM(getMessage());
          case 6: return new TS(getMessage());
          case 7: return new TS(getMessage());
          case 8: return new CE(getMessage());
          case 9: return new CE(getMessage());
          case 10: return new CE(getMessage());
          case 11: return new TS(getMessage());
          case 12: return new TS(getMessage());
          case 13: return new TS(getMessage());
          case 14: return new TQ(getMessage());
          case 15: return new CE(getMessage());
          case 16: return new ST(getMessage());
          case 17: return new CE(getMessage());
          case 18: return new TS(getMessage());
          case 19: return new CE(getMessage());
          case 20: return new XPN(getMessage());
          default: return null;
       }
   }


}

