/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v251.segment;

// import ca.uhn.hl7v2.model.v251.group.*;
import ca.uhn.hl7v2.model.v251.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 GP2 message segment (Grouping/Reimbursement - Procedure Line Item). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>GP2-1: Revenue Code (IS) <b>optional </b>
     * <li>GP2-2: Number of Service Units (NM) <b>optional </b>
     * <li>GP2-3: Charge (CP) <b>optional </b>
     * <li>GP2-4: Reimbursement Action Code (IS) <b>optional </b>
     * <li>GP2-5: Denial or Rejection Code (IS) <b>optional </b>
     * <li>GP2-6: OCE Edit Code (IS) <b>optional repeating</b>
     * <li>GP2-7: Ambulatory Payment Classification Code (CE) <b>optional </b>
     * <li>GP2-8: Modifier Edit Code (IS) <b>optional repeating</b>
     * <li>GP2-9: Payment Adjustment Code (IS) <b>optional </b>
     * <li>GP2-10: Packaging Status Code (IS) <b>optional </b>
     * <li>GP2-11: Expected CMS Payment Amount (CP) <b>optional </b>
     * <li>GP2-12: Reimbursement Type Code (IS) <b>optional </b>
     * <li>GP2-13: Co-Pay Amount (CP) <b>optional </b>
     * <li>GP2-14: Pay Rate per Service Unit (NM) <b>optional </b>
 * </ul>
 */
public class GP2 extends AbstractSegment {

    /** 
     * Creates a new GP2 segment
     */
    public GP2(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(IS.class, false, 1, 3, new Object[]{ getMessage() }, "Revenue Code");
                                  this.add(NM.class, false, 1, 7, new Object[]{ getMessage(), new Integer(0) }, "Number of Service Units");
                                  this.add(CP.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Charge");
                                  this.add(IS.class, false, 1, 1, new Object[]{ getMessage() }, "Reimbursement Action Code");
                                  this.add(IS.class, false, 1, 1, new Object[]{ getMessage() }, "Denial or Rejection Code");
                                  this.add(IS.class, false, 0, 3, new Object[]{ getMessage() }, "OCE Edit Code");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(466) }, "Ambulatory Payment Classification Code");
                                  this.add(IS.class, false, 0, 1, new Object[]{ getMessage() }, "Modifier Edit Code");
                                  this.add(IS.class, false, 1, 1, new Object[]{ getMessage() }, "Payment Adjustment Code");
                                  this.add(IS.class, false, 1, 1, new Object[]{ getMessage() }, "Packaging Status Code");
                                  this.add(CP.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Expected CMS Payment Amount");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Reimbursement Type Code");
                                  this.add(CP.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Co-Pay Amount");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Pay Rate per Service Unit");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating GP2 - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * GP2-1: "Revenue Code" - creates it if necessary
     */
    public IS getRevenueCode() { 
        IS ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GP2-1: "Revenue Code" - creates it if necessary
     */
    public IS getGp21_RevenueCode() { 
        IS ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GP2-2: "Number of Service Units" - creates it if necessary
     */
    public NM getNumberOfServiceUnits() { 
        NM ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GP2-2: "Number of Service Units" - creates it if necessary
     */
    public NM getGp22_NumberOfServiceUnits() { 
        NM ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GP2-3: "Charge" - creates it if necessary
     */
    public CP getCharge() { 
        CP ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GP2-3: "Charge" - creates it if necessary
     */
    public CP getGp23_Charge() { 
        CP ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GP2-4: "Reimbursement Action Code" - creates it if necessary
     */
    public IS getReimbursementActionCode() { 
        IS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GP2-4: "Reimbursement Action Code" - creates it if necessary
     */
    public IS getGp24_ReimbursementActionCode() { 
        IS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GP2-5: "Denial or Rejection Code" - creates it if necessary
     */
    public IS getDenialOrRejectionCode() { 
        IS ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GP2-5: "Denial or Rejection Code" - creates it if necessary
     */
    public IS getGp25_DenialOrRejectionCode() { 
        IS ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of OCE Edit Code (GP2-6).
     */
    public IS[] getOCEEditCode() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(6);  
            ret = new IS[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (IS)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GP2-6: "OCE Edit Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public IS getOCEEditCode(int rep) { 
        IS ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GP2-6: "OCE Edit Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public IS getGp26_OCEEditCode(int rep) { 
        IS ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * GP2-6: "OCE Edit Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS insertOCEEditCode(int rep) throws HL7Exception { 
        return (IS) super.insertRepetition(6, rep);
    }



    /**
     * Inserts a repetition of
     * GP2-6: "OCE Edit Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS insertGp26_OCEEditCode(int rep) throws HL7Exception { 
        return (IS) super.insertRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * GP2-6: "OCE Edit Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS removeOCEEditCode(int rep) throws HL7Exception { 
        return (IS) super.removeRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * GP2-6: "OCE Edit Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS removeGp26_OCEEditCode(int rep) throws HL7Exception { 
        return (IS) super.removeRepetition(6, rep);
    }




    /**
     * Returns
     * GP2-7: "Ambulatory Payment Classification Code" - creates it if necessary
     */
    public CE getAmbulatoryPaymentClassificationCode() { 
        CE ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GP2-7: "Ambulatory Payment Classification Code" - creates it if necessary
     */
    public CE getGp27_AmbulatoryPaymentClassificationCode() { 
        CE ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Modifier Edit Code (GP2-8).
     */
    public IS[] getModifierEditCode() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(8);  
            ret = new IS[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (IS)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GP2-8: "Modifier Edit Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public IS getModifierEditCode(int rep) { 
        IS ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GP2-8: "Modifier Edit Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public IS getGp28_ModifierEditCode(int rep) { 
        IS ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * GP2-8: "Modifier Edit Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS insertModifierEditCode(int rep) throws HL7Exception { 
        return (IS) super.insertRepetition(8, rep);
    }



    /**
     * Inserts a repetition of
     * GP2-8: "Modifier Edit Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS insertGp28_ModifierEditCode(int rep) throws HL7Exception { 
        return (IS) super.insertRepetition(8, rep);
    }


    /**
     * Removes a repetition of
     * GP2-8: "Modifier Edit Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS removeModifierEditCode(int rep) throws HL7Exception { 
        return (IS) super.removeRepetition(8, rep);
    }


    /**
     * Removes a repetition of
     * GP2-8: "Modifier Edit Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS removeGp28_ModifierEditCode(int rep) throws HL7Exception { 
        return (IS) super.removeRepetition(8, rep);
    }




    /**
     * Returns
     * GP2-9: "Payment Adjustment Code" - creates it if necessary
     */
    public IS getPaymentAdjustmentCode() { 
        IS ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GP2-9: "Payment Adjustment Code" - creates it if necessary
     */
    public IS getGp29_PaymentAdjustmentCode() { 
        IS ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GP2-10: "Packaging Status Code" - creates it if necessary
     */
    public IS getPackagingStatusCode() { 
        IS ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GP2-10: "Packaging Status Code" - creates it if necessary
     */
    public IS getGp210_PackagingStatusCode() { 
        IS ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GP2-11: "Expected CMS Payment Amount" - creates it if necessary
     */
    public CP getExpectedCMSPaymentAmount() { 
        CP ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GP2-11: "Expected CMS Payment Amount" - creates it if necessary
     */
    public CP getGp211_ExpectedCMSPaymentAmount() { 
        CP ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GP2-12: "Reimbursement Type Code" - creates it if necessary
     */
    public IS getReimbursementTypeCode() { 
        IS ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GP2-12: "Reimbursement Type Code" - creates it if necessary
     */
    public IS getGp212_ReimbursementTypeCode() { 
        IS ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GP2-13: "Co-Pay Amount" - creates it if necessary
     */
    public CP getCoPayAmount() { 
        CP ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GP2-13: "Co-Pay Amount" - creates it if necessary
     */
    public CP getGp213_CoPayAmount() { 
        CP ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * GP2-14: "Pay Rate per Service Unit" - creates it if necessary
     */
    public NM getPayRatePerServiceUnit() { 
        NM ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GP2-14: "Pay Rate per Service Unit" - creates it if necessary
     */
    public NM getGp214_PayRatePerServiceUnit() { 
        NM ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new IS(getMessage(), new Integer( 456 ));
          case 1: return new NM(getMessage());
          case 2: return new CP(getMessage());
          case 3: return new IS(getMessage(), new Integer( 459 ));
          case 4: return new IS(getMessage(), new Integer( 460 ));
          case 5: return new IS(getMessage(), new Integer( 458 ));
          case 6: return new CE(getMessage());
          case 7: return new IS(getMessage(), new Integer( 467 ));
          case 8: return new IS(getMessage(), new Integer( 468 ));
          case 9: return new IS(getMessage(), new Integer( 469 ));
          case 10: return new CP(getMessage());
          case 11: return new IS(getMessage(), new Integer( 470 ));
          case 12: return new CP(getMessage());
          case 13: return new NM(getMessage());
          default: return null;
       }
   }


}

