/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v251.segment;

// import ca.uhn.hl7v2.model.v251.group.*;
import ca.uhn.hl7v2.model.v251.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 PEO message segment (Product Experience Observation). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>PEO-1: Event Identifiers Used (CE) <b>optional repeating</b>
     * <li>PEO-2: Event Symptom/Diagnosis Code (CE) <b>optional repeating</b>
     * <li>PEO-3: Event Onset Date/Time (TS) <b> </b>
     * <li>PEO-4: Event Exacerbation Date/Time (TS) <b>optional </b>
     * <li>PEO-5: Event Improved Date/Time (TS) <b>optional </b>
     * <li>PEO-6: Event Ended Data/Time (TS) <b>optional </b>
     * <li>PEO-7: Event Location Occurred Address (XAD) <b>optional repeating</b>
     * <li>PEO-8: Event Qualification (ID) <b>optional repeating</b>
     * <li>PEO-9: Event Serious (ID) <b>optional </b>
     * <li>PEO-10: Event Expected (ID) <b>optional </b>
     * <li>PEO-11: Event Outcome (ID) <b>optional repeating</b>
     * <li>PEO-12: Patient Outcome (ID) <b>optional </b>
     * <li>PEO-13: Event Description From Others (FT) <b>optional repeating</b>
     * <li>PEO-14: Event From Original Reporter (FT) <b>optional repeating</b>
     * <li>PEO-15: Event Description From Patient (FT) <b>optional repeating</b>
     * <li>PEO-16: Event Description From Practitioner (FT) <b>optional repeating</b>
     * <li>PEO-17: Event Description From Autopsy (FT) <b>optional repeating</b>
     * <li>PEO-18: Cause Of Death (CE) <b>optional repeating</b>
     * <li>PEO-19: Primary Observer Name (XPN) <b>optional repeating</b>
     * <li>PEO-20: Primary Observer Address (XAD) <b>optional repeating</b>
     * <li>PEO-21: Primary Observer Telephone (XTN) <b>optional repeating</b>
     * <li>PEO-22: Primary Observer's Qualification (ID) <b>optional </b>
     * <li>PEO-23: Confirmation Provided By (ID) <b>optional </b>
     * <li>PEO-24: Primary Observer Aware Date/Time (TS) <b>optional </b>
     * <li>PEO-25: Primary Observer's identity May Be Divulged (ID) <b>optional </b>
 * </ul>
 */
public class PEO extends AbstractSegment {

    /** 
     * Creates a new PEO segment
     */
    public PEO(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(CE.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Event Identifiers Used");
                                  this.add(CE.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Event Symptom/Diagnosis Code");
                                  this.add(TS.class, true, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Event Onset Date/Time");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Event Exacerbation Date/Time");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Event Improved Date/Time");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Event Ended Data/Time");
                                  this.add(XAD.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Event Location Occurred Address");
                                  this.add(ID.class, false, 0, 1, new Object[]{ getMessage() }, "Event Qualification");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Event Serious");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Event Expected");
                                  this.add(ID.class, false, 0, 1, new Object[]{ getMessage() }, "Event Outcome");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Patient Outcome");
                                  this.add(FT.class, false, 0, 600, new Object[]{ getMessage(), new Integer(0) }, "Event Description From Others");
                                  this.add(FT.class, false, 0, 600, new Object[]{ getMessage(), new Integer(0) }, "Event From Original Reporter");
                                  this.add(FT.class, false, 0, 600, new Object[]{ getMessage(), new Integer(0) }, "Event Description From Patient");
                                  this.add(FT.class, false, 0, 600, new Object[]{ getMessage(), new Integer(0) }, "Event Description From Practitioner");
                                  this.add(FT.class, false, 0, 600, new Object[]{ getMessage(), new Integer(0) }, "Event Description From Autopsy");
                                  this.add(CE.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Cause Of Death");
                                  this.add(XPN.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Primary Observer Name");
                                  this.add(XAD.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Primary Observer Address");
                                  this.add(XTN.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Primary Observer Telephone");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Primary Observer's Qualification");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Confirmation Provided By");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Primary Observer Aware Date/Time");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Primary Observer's identity May Be Divulged");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PEO - this is probably a bug in the source code generator.", e);
       }
    }


    /**
     * Returns all repetitions of Event Identifiers Used (PEO-1).
     */
    public CE[] getEventIdentifiersUsed() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(1);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-1: "Event Identifiers Used" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getEventIdentifiersUsed(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-1: "Event Identifiers Used" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getPeo1_EventIdentifiersUsed(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PEO-1: "Event Identifiers Used" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertEventIdentifiersUsed(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(1, rep);
    }



    /**
     * Inserts a repetition of
     * PEO-1: "Event Identifiers Used" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertPeo1_EventIdentifiersUsed(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(1, rep);
    }


    /**
     * Removes a repetition of
     * PEO-1: "Event Identifiers Used" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeEventIdentifiersUsed(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(1, rep);
    }


    /**
     * Removes a repetition of
     * PEO-1: "Event Identifiers Used" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removePeo1_EventIdentifiersUsed(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(1, rep);
    }



    /**
     * Returns all repetitions of Event Symptom/Diagnosis Code (PEO-2).
     */
    public CE[] getEventSymptomDiagnosisCode() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(2);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-2: "Event Symptom/Diagnosis Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getEventSymptomDiagnosisCode(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-2: "Event Symptom/Diagnosis Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getPeo2_EventSymptomDiagnosisCode(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PEO-2: "Event Symptom/Diagnosis Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertEventSymptomDiagnosisCode(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(2, rep);
    }



    /**
     * Inserts a repetition of
     * PEO-2: "Event Symptom/Diagnosis Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertPeo2_EventSymptomDiagnosisCode(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * PEO-2: "Event Symptom/Diagnosis Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeEventSymptomDiagnosisCode(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * PEO-2: "Event Symptom/Diagnosis Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removePeo2_EventSymptomDiagnosisCode(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(2, rep);
    }




    /**
     * Returns
     * PEO-3: "Event Onset Date/Time" - creates it if necessary
     */
    public TS getEventOnsetDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PEO-3: "Event Onset Date/Time" - creates it if necessary
     */
    public TS getPeo3_EventOnsetDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PEO-4: "Event Exacerbation Date/Time" - creates it if necessary
     */
    public TS getEventExacerbationDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PEO-4: "Event Exacerbation Date/Time" - creates it if necessary
     */
    public TS getPeo4_EventExacerbationDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PEO-5: "Event Improved Date/Time" - creates it if necessary
     */
    public TS getEventImprovedDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PEO-5: "Event Improved Date/Time" - creates it if necessary
     */
    public TS getPeo5_EventImprovedDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PEO-6: "Event Ended Data/Time" - creates it if necessary
     */
    public TS getEventEndedDataTime() { 
        TS ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PEO-6: "Event Ended Data/Time" - creates it if necessary
     */
    public TS getPeo6_EventEndedDataTime() { 
        TS ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Event Location Occurred Address (PEO-7).
     */
    public XAD[] getEventLocationOccurredAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(7);  
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XAD)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-7: "Event Location Occurred Address" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getEventLocationOccurredAddress(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-7: "Event Location Occurred Address" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getPeo7_EventLocationOccurredAddress(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PEO-7: "Event Location Occurred Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertEventLocationOccurredAddress(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(7, rep);
    }



    /**
     * Inserts a repetition of
     * PEO-7: "Event Location Occurred Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertPeo7_EventLocationOccurredAddress(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * PEO-7: "Event Location Occurred Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removeEventLocationOccurredAddress(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * PEO-7: "Event Location Occurred Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removePeo7_EventLocationOccurredAddress(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(7, rep);
    }



    /**
     * Returns all repetitions of Event Qualification (PEO-8).
     */
    public ID[] getEventQualification() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(8);  
            ret = new ID[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ID)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-8: "Event Qualification" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getEventQualification(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-8: "Event Qualification" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getPeo8_EventQualification(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PEO-8: "Event Qualification" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertEventQualification(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(8, rep);
    }



    /**
     * Inserts a repetition of
     * PEO-8: "Event Qualification" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertPeo8_EventQualification(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(8, rep);
    }


    /**
     * Removes a repetition of
     * PEO-8: "Event Qualification" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removeEventQualification(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(8, rep);
    }


    /**
     * Removes a repetition of
     * PEO-8: "Event Qualification" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removePeo8_EventQualification(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(8, rep);
    }




    /**
     * Returns
     * PEO-9: "Event Serious" - creates it if necessary
     */
    public ID getEventSerious() { 
        ID ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PEO-9: "Event Serious" - creates it if necessary
     */
    public ID getPeo9_EventSerious() { 
        ID ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PEO-10: "Event Expected" - creates it if necessary
     */
    public ID getEventExpected() { 
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PEO-10: "Event Expected" - creates it if necessary
     */
    public ID getPeo10_EventExpected() { 
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Event Outcome (PEO-11).
     */
    public ID[] getEventOutcome() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(11);  
            ret = new ID[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ID)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-11: "Event Outcome" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getEventOutcome(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-11: "Event Outcome" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getPeo11_EventOutcome(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PEO-11: "Event Outcome" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertEventOutcome(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(11, rep);
    }



    /**
     * Inserts a repetition of
     * PEO-11: "Event Outcome" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertPeo11_EventOutcome(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(11, rep);
    }


    /**
     * Removes a repetition of
     * PEO-11: "Event Outcome" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removeEventOutcome(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(11, rep);
    }


    /**
     * Removes a repetition of
     * PEO-11: "Event Outcome" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removePeo11_EventOutcome(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(11, rep);
    }




    /**
     * Returns
     * PEO-12: "Patient Outcome" - creates it if necessary
     */
    public ID getPatientOutcome() { 
        ID ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PEO-12: "Patient Outcome" - creates it if necessary
     */
    public ID getPeo12_PatientOutcome() { 
        ID ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Event Description From Others (PEO-13).
     */
    public FT[] getEventDescriptionFromOthers() {
        FT[] ret = null;
        try {
            Type[] t = this.getField(13);  
            ret = new FT[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (FT)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-13: "Event Description From Others" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public FT getEventDescriptionFromOthers(int rep) { 
        FT ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (FT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-13: "Event Description From Others" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public FT getPeo13_EventDescriptionFromOthers(int rep) { 
        FT ret = null;
        try {
            Type t = this.getField(13, rep);
            ret = (FT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PEO-13: "Event Description From Others" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public FT insertEventDescriptionFromOthers(int rep) throws HL7Exception { 
        return (FT) super.insertRepetition(13, rep);
    }



    /**
     * Inserts a repetition of
     * PEO-13: "Event Description From Others" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public FT insertPeo13_EventDescriptionFromOthers(int rep) throws HL7Exception { 
        return (FT) super.insertRepetition(13, rep);
    }


    /**
     * Removes a repetition of
     * PEO-13: "Event Description From Others" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public FT removeEventDescriptionFromOthers(int rep) throws HL7Exception { 
        return (FT) super.removeRepetition(13, rep);
    }


    /**
     * Removes a repetition of
     * PEO-13: "Event Description From Others" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public FT removePeo13_EventDescriptionFromOthers(int rep) throws HL7Exception { 
        return (FT) super.removeRepetition(13, rep);
    }



    /**
     * Returns all repetitions of Event From Original Reporter (PEO-14).
     */
    public FT[] getEventFromOriginalReporter() {
        FT[] ret = null;
        try {
            Type[] t = this.getField(14);  
            ret = new FT[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (FT)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-14: "Event From Original Reporter" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public FT getEventFromOriginalReporter(int rep) { 
        FT ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (FT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-14: "Event From Original Reporter" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public FT getPeo14_EventFromOriginalReporter(int rep) { 
        FT ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (FT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PEO-14: "Event From Original Reporter" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public FT insertEventFromOriginalReporter(int rep) throws HL7Exception { 
        return (FT) super.insertRepetition(14, rep);
    }



    /**
     * Inserts a repetition of
     * PEO-14: "Event From Original Reporter" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public FT insertPeo14_EventFromOriginalReporter(int rep) throws HL7Exception { 
        return (FT) super.insertRepetition(14, rep);
    }


    /**
     * Removes a repetition of
     * PEO-14: "Event From Original Reporter" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public FT removeEventFromOriginalReporter(int rep) throws HL7Exception { 
        return (FT) super.removeRepetition(14, rep);
    }


    /**
     * Removes a repetition of
     * PEO-14: "Event From Original Reporter" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public FT removePeo14_EventFromOriginalReporter(int rep) throws HL7Exception { 
        return (FT) super.removeRepetition(14, rep);
    }



    /**
     * Returns all repetitions of Event Description From Patient (PEO-15).
     */
    public FT[] getEventDescriptionFromPatient() {
        FT[] ret = null;
        try {
            Type[] t = this.getField(15);  
            ret = new FT[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (FT)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-15: "Event Description From Patient" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public FT getEventDescriptionFromPatient(int rep) { 
        FT ret = null;
        try {
            Type t = this.getField(15, rep);
            ret = (FT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-15: "Event Description From Patient" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public FT getPeo15_EventDescriptionFromPatient(int rep) { 
        FT ret = null;
        try {
            Type t = this.getField(15, rep);
            ret = (FT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PEO-15: "Event Description From Patient" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public FT insertEventDescriptionFromPatient(int rep) throws HL7Exception { 
        return (FT) super.insertRepetition(15, rep);
    }



    /**
     * Inserts a repetition of
     * PEO-15: "Event Description From Patient" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public FT insertPeo15_EventDescriptionFromPatient(int rep) throws HL7Exception { 
        return (FT) super.insertRepetition(15, rep);
    }


    /**
     * Removes a repetition of
     * PEO-15: "Event Description From Patient" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public FT removeEventDescriptionFromPatient(int rep) throws HL7Exception { 
        return (FT) super.removeRepetition(15, rep);
    }


    /**
     * Removes a repetition of
     * PEO-15: "Event Description From Patient" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public FT removePeo15_EventDescriptionFromPatient(int rep) throws HL7Exception { 
        return (FT) super.removeRepetition(15, rep);
    }



    /**
     * Returns all repetitions of Event Description From Practitioner (PEO-16).
     */
    public FT[] getEventDescriptionFromPractitioner() {
        FT[] ret = null;
        try {
            Type[] t = this.getField(16);  
            ret = new FT[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (FT)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-16: "Event Description From Practitioner" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public FT getEventDescriptionFromPractitioner(int rep) { 
        FT ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (FT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-16: "Event Description From Practitioner" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public FT getPeo16_EventDescriptionFromPractitioner(int rep) { 
        FT ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (FT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PEO-16: "Event Description From Practitioner" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public FT insertEventDescriptionFromPractitioner(int rep) throws HL7Exception { 
        return (FT) super.insertRepetition(16, rep);
    }



    /**
     * Inserts a repetition of
     * PEO-16: "Event Description From Practitioner" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public FT insertPeo16_EventDescriptionFromPractitioner(int rep) throws HL7Exception { 
        return (FT) super.insertRepetition(16, rep);
    }


    /**
     * Removes a repetition of
     * PEO-16: "Event Description From Practitioner" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public FT removeEventDescriptionFromPractitioner(int rep) throws HL7Exception { 
        return (FT) super.removeRepetition(16, rep);
    }


    /**
     * Removes a repetition of
     * PEO-16: "Event Description From Practitioner" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public FT removePeo16_EventDescriptionFromPractitioner(int rep) throws HL7Exception { 
        return (FT) super.removeRepetition(16, rep);
    }



    /**
     * Returns all repetitions of Event Description From Autopsy (PEO-17).
     */
    public FT[] getEventDescriptionFromAutopsy() {
        FT[] ret = null;
        try {
            Type[] t = this.getField(17);  
            ret = new FT[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (FT)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-17: "Event Description From Autopsy" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public FT getEventDescriptionFromAutopsy(int rep) { 
        FT ret = null;
        try {
            Type t = this.getField(17, rep);
            ret = (FT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-17: "Event Description From Autopsy" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public FT getPeo17_EventDescriptionFromAutopsy(int rep) { 
        FT ret = null;
        try {
            Type t = this.getField(17, rep);
            ret = (FT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PEO-17: "Event Description From Autopsy" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public FT insertEventDescriptionFromAutopsy(int rep) throws HL7Exception { 
        return (FT) super.insertRepetition(17, rep);
    }



    /**
     * Inserts a repetition of
     * PEO-17: "Event Description From Autopsy" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public FT insertPeo17_EventDescriptionFromAutopsy(int rep) throws HL7Exception { 
        return (FT) super.insertRepetition(17, rep);
    }


    /**
     * Removes a repetition of
     * PEO-17: "Event Description From Autopsy" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public FT removeEventDescriptionFromAutopsy(int rep) throws HL7Exception { 
        return (FT) super.removeRepetition(17, rep);
    }


    /**
     * Removes a repetition of
     * PEO-17: "Event Description From Autopsy" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public FT removePeo17_EventDescriptionFromAutopsy(int rep) throws HL7Exception { 
        return (FT) super.removeRepetition(17, rep);
    }



    /**
     * Returns all repetitions of Cause Of Death (PEO-18).
     */
    public CE[] getCauseOfDeath() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(18);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-18: "Cause Of Death" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getCauseOfDeath(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(18, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-18: "Cause Of Death" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getPeo18_CauseOfDeath(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(18, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PEO-18: "Cause Of Death" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertCauseOfDeath(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(18, rep);
    }



    /**
     * Inserts a repetition of
     * PEO-18: "Cause Of Death" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertPeo18_CauseOfDeath(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(18, rep);
    }


    /**
     * Removes a repetition of
     * PEO-18: "Cause Of Death" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeCauseOfDeath(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(18, rep);
    }


    /**
     * Removes a repetition of
     * PEO-18: "Cause Of Death" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removePeo18_CauseOfDeath(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(18, rep);
    }



    /**
     * Returns all repetitions of Primary Observer Name (PEO-19).
     */
    public XPN[] getPrimaryObserverName() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(19);  
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XPN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-19: "Primary Observer Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getPrimaryObserverName(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(19, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-19: "Primary Observer Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getPeo19_PrimaryObserverName(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(19, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PEO-19: "Primary Observer Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertPrimaryObserverName(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(19, rep);
    }



    /**
     * Inserts a repetition of
     * PEO-19: "Primary Observer Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertPeo19_PrimaryObserverName(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(19, rep);
    }


    /**
     * Removes a repetition of
     * PEO-19: "Primary Observer Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removePrimaryObserverName(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(19, rep);
    }


    /**
     * Removes a repetition of
     * PEO-19: "Primary Observer Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removePeo19_PrimaryObserverName(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(19, rep);
    }



    /**
     * Returns all repetitions of Primary Observer Address (PEO-20).
     */
    public XAD[] getPrimaryObserverAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(20);  
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XAD)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-20: "Primary Observer Address" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getPrimaryObserverAddress(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(20, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-20: "Primary Observer Address" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getPeo20_PrimaryObserverAddress(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(20, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PEO-20: "Primary Observer Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertPrimaryObserverAddress(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(20, rep);
    }



    /**
     * Inserts a repetition of
     * PEO-20: "Primary Observer Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertPeo20_PrimaryObserverAddress(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(20, rep);
    }


    /**
     * Removes a repetition of
     * PEO-20: "Primary Observer Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removePrimaryObserverAddress(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(20, rep);
    }


    /**
     * Removes a repetition of
     * PEO-20: "Primary Observer Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removePeo20_PrimaryObserverAddress(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(20, rep);
    }



    /**
     * Returns all repetitions of Primary Observer Telephone (PEO-21).
     */
    public XTN[] getPrimaryObserverTelephone() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(21);  
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XTN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-21: "Primary Observer Telephone" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getPrimaryObserverTelephone(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(21, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PEO-21: "Primary Observer Telephone" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getPeo21_PrimaryObserverTelephone(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(21, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PEO-21: "Primary Observer Telephone" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertPrimaryObserverTelephone(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(21, rep);
    }



    /**
     * Inserts a repetition of
     * PEO-21: "Primary Observer Telephone" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertPeo21_PrimaryObserverTelephone(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(21, rep);
    }


    /**
     * Removes a repetition of
     * PEO-21: "Primary Observer Telephone" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removePrimaryObserverTelephone(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(21, rep);
    }


    /**
     * Removes a repetition of
     * PEO-21: "Primary Observer Telephone" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removePeo21_PrimaryObserverTelephone(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(21, rep);
    }




    /**
     * Returns
     * PEO-22: "Primary Observer's Qualification" - creates it if necessary
     */
    public ID getPrimaryObserverSQualification() { 
        ID ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PEO-22: "Primary Observer's Qualification" - creates it if necessary
     */
    public ID getPeo22_PrimaryObserverSQualification() { 
        ID ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PEO-23: "Confirmation Provided By" - creates it if necessary
     */
    public ID getConfirmationProvidedBy() { 
        ID ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PEO-23: "Confirmation Provided By" - creates it if necessary
     */
    public ID getPeo23_ConfirmationProvidedBy() { 
        ID ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PEO-24: "Primary Observer Aware Date/Time" - creates it if necessary
     */
    public TS getPrimaryObserverAwareDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PEO-24: "Primary Observer Aware Date/Time" - creates it if necessary
     */
    public TS getPeo24_PrimaryObserverAwareDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PEO-25: "Primary Observer's identity May Be Divulged" - creates it if necessary
     */
    public ID getPrimaryObserverSIdentityMayBeDivulged() { 
        ID ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PEO-25: "Primary Observer's identity May Be Divulged" - creates it if necessary
     */
    public ID getPeo25_PrimaryObserverSIdentityMayBeDivulged() { 
        ID ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new CE(getMessage());
          case 1: return new CE(getMessage());
          case 2: return new TS(getMessage());
          case 3: return new TS(getMessage());
          case 4: return new TS(getMessage());
          case 5: return new TS(getMessage());
          case 6: return new XAD(getMessage());
          case 7: return new ID(getMessage(), new Integer( 237 ));
          case 8: return new ID(getMessage(), new Integer( 238 ));
          case 9: return new ID(getMessage(), new Integer( 239 ));
          case 10: return new ID(getMessage(), new Integer( 240 ));
          case 11: return new ID(getMessage(), new Integer( 241 ));
          case 12: return new FT(getMessage());
          case 13: return new FT(getMessage());
          case 14: return new FT(getMessage());
          case 15: return new FT(getMessage());
          case 16: return new FT(getMessage());
          case 17: return new CE(getMessage());
          case 18: return new XPN(getMessage());
          case 19: return new XAD(getMessage());
          case 20: return new XTN(getMessage());
          case 21: return new ID(getMessage(), new Integer( 242 ));
          case 22: return new ID(getMessage(), new Integer( 242 ));
          case 23: return new TS(getMessage());
          case 24: return new ID(getMessage(), new Integer( 243 ));
          default: return null;
       }
   }


}

