/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v251.segment;

// import ca.uhn.hl7v2.model.v251.group.*;
import ca.uhn.hl7v2.model.v251.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 PRC message segment (Pricing). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>PRC-1: Primary Key Value - PRC (CE) <b> </b>
     * <li>PRC-2: Facility ID - PRC (CE) <b>optional repeating</b>
     * <li>PRC-3: Department (CE) <b>optional repeating</b>
     * <li>PRC-4: Valid Patient Classes (IS) <b>optional repeating</b>
     * <li>PRC-5: Price (CP) <b>optional repeating</b>
     * <li>PRC-6: Formula (ST) <b>optional repeating</b>
     * <li>PRC-7: Minimum Quantity (NM) <b>optional </b>
     * <li>PRC-8: Maximum Quantity (NM) <b>optional </b>
     * <li>PRC-9: Minimum Price (MO) <b>optional </b>
     * <li>PRC-10: Maximum Price (MO) <b>optional </b>
     * <li>PRC-11: Effective Start Date (TS) <b>optional </b>
     * <li>PRC-12: Effective End Date (TS) <b>optional </b>
     * <li>PRC-13: Price Override Flag (IS) <b>optional </b>
     * <li>PRC-14: Billing Category (CE) <b>optional repeating</b>
     * <li>PRC-15: Chargeable Flag (ID) <b>optional </b>
     * <li>PRC-16: Active/Inactive Flag (ID) <b>optional </b>
     * <li>PRC-17: Cost (MO) <b>optional </b>
     * <li>PRC-18: Charge On Indicator (IS) <b>optional </b>
 * </ul>
 */
public class PRC extends AbstractSegment {

    /** 
     * Creates a new PRC segment
     */
    public PRC(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(CE.class, true, 1, 250, new Object[]{ getMessage(), new Integer(132) }, "Primary Key Value - PRC");
                                  this.add(CE.class, false, 0, 250, new Object[]{ getMessage(), new Integer(464) }, "Facility ID - PRC");
                                  this.add(CE.class, false, 0, 250, new Object[]{ getMessage(), new Integer(184) }, "Department");
                                  this.add(IS.class, false, 0, 1, new Object[]{ getMessage() }, "Valid Patient Classes");
                                  this.add(CP.class, false, 0, 12, new Object[]{ getMessage(), new Integer(0) }, "Price");
                                  this.add(ST.class, false, 0, 200, new Object[]{ getMessage(), new Integer(0) }, "Formula");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Minimum Quantity");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Maximum Quantity");
                                  this.add(MO.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Minimum Price");
                                  this.add(MO.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Maximum Price");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Effective Start Date");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Effective End Date");
                                  this.add(IS.class, false, 1, 1, new Object[]{ getMessage() }, "Price Override Flag");
                                  this.add(CE.class, false, 0, 250, new Object[]{ getMessage(), new Integer(293) }, "Billing Category");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Chargeable Flag");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Active/Inactive Flag");
                                  this.add(MO.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Cost");
                                  this.add(IS.class, false, 1, 1, new Object[]{ getMessage() }, "Charge On Indicator");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PRC - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * PRC-1: "Primary Key Value - PRC" - creates it if necessary
     */
    public CE getPrimaryKeyValuePRC() { 
        CE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRC-1: "Primary Key Value - PRC" - creates it if necessary
     */
    public CE getPrc1_PrimaryKeyValuePRC() { 
        CE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Facility ID - PRC (PRC-2).
     */
    public CE[] getFacilityIDPRC() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(2);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRC-2: "Facility ID - PRC" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getFacilityIDPRC(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRC-2: "Facility ID - PRC" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getPrc2_FacilityIDPRC(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PRC-2: "Facility ID - PRC" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertFacilityIDPRC(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(2, rep);
    }



    /**
     * Inserts a repetition of
     * PRC-2: "Facility ID - PRC" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertPrc2_FacilityIDPRC(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * PRC-2: "Facility ID - PRC" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeFacilityIDPRC(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * PRC-2: "Facility ID - PRC" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removePrc2_FacilityIDPRC(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(2, rep);
    }



    /**
     * Returns all repetitions of Department (PRC-3).
     */
    public CE[] getDepartment() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(3);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRC-3: "Department" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getDepartment(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRC-3: "Department" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getPrc3_Department(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PRC-3: "Department" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertDepartment(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(3, rep);
    }



    /**
     * Inserts a repetition of
     * PRC-3: "Department" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertPrc3_Department(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * PRC-3: "Department" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeDepartment(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * PRC-3: "Department" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removePrc3_Department(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(3, rep);
    }



    /**
     * Returns all repetitions of Valid Patient Classes (PRC-4).
     */
    public IS[] getValidPatientClasses() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(4);  
            ret = new IS[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (IS)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRC-4: "Valid Patient Classes" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public IS getValidPatientClasses(int rep) { 
        IS ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRC-4: "Valid Patient Classes" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public IS getPrc4_ValidPatientClasses(int rep) { 
        IS ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PRC-4: "Valid Patient Classes" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS insertValidPatientClasses(int rep) throws HL7Exception { 
        return (IS) super.insertRepetition(4, rep);
    }



    /**
     * Inserts a repetition of
     * PRC-4: "Valid Patient Classes" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS insertPrc4_ValidPatientClasses(int rep) throws HL7Exception { 
        return (IS) super.insertRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * PRC-4: "Valid Patient Classes" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS removeValidPatientClasses(int rep) throws HL7Exception { 
        return (IS) super.removeRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * PRC-4: "Valid Patient Classes" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS removePrc4_ValidPatientClasses(int rep) throws HL7Exception { 
        return (IS) super.removeRepetition(4, rep);
    }



    /**
     * Returns all repetitions of Price (PRC-5).
     */
    public CP[] getPrice() {
        CP[] ret = null;
        try {
            Type[] t = this.getField(5);  
            ret = new CP[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CP)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRC-5: "Price" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CP getPrice(int rep) { 
        CP ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRC-5: "Price" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CP getPrc5_Price(int rep) { 
        CP ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PRC-5: "Price" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CP insertPrice(int rep) throws HL7Exception { 
        return (CP) super.insertRepetition(5, rep);
    }



    /**
     * Inserts a repetition of
     * PRC-5: "Price" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CP insertPrc5_Price(int rep) throws HL7Exception { 
        return (CP) super.insertRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * PRC-5: "Price" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CP removePrice(int rep) throws HL7Exception { 
        return (CP) super.removeRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * PRC-5: "Price" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CP removePrc5_Price(int rep) throws HL7Exception { 
        return (CP) super.removeRepetition(5, rep);
    }



    /**
     * Returns all repetitions of Formula (PRC-6).
     */
    public ST[] getFormula() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(6);  
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ST)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRC-6: "Formula" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getFormula(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRC-6: "Formula" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getPrc6_Formula(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PRC-6: "Formula" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertFormula(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(6, rep);
    }



    /**
     * Inserts a repetition of
     * PRC-6: "Formula" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertPrc6_Formula(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * PRC-6: "Formula" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeFormula(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * PRC-6: "Formula" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removePrc6_Formula(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(6, rep);
    }




    /**
     * Returns
     * PRC-7: "Minimum Quantity" - creates it if necessary
     */
    public NM getMinimumQuantity() { 
        NM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRC-7: "Minimum Quantity" - creates it if necessary
     */
    public NM getPrc7_MinimumQuantity() { 
        NM ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRC-8: "Maximum Quantity" - creates it if necessary
     */
    public NM getMaximumQuantity() { 
        NM ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRC-8: "Maximum Quantity" - creates it if necessary
     */
    public NM getPrc8_MaximumQuantity() { 
        NM ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRC-9: "Minimum Price" - creates it if necessary
     */
    public MO getMinimumPrice() { 
        MO ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (MO)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRC-9: "Minimum Price" - creates it if necessary
     */
    public MO getPrc9_MinimumPrice() { 
        MO ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (MO)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRC-10: "Maximum Price" - creates it if necessary
     */
    public MO getMaximumPrice() { 
        MO ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (MO)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRC-10: "Maximum Price" - creates it if necessary
     */
    public MO getPrc10_MaximumPrice() { 
        MO ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (MO)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRC-11: "Effective Start Date" - creates it if necessary
     */
    public TS getEffectiveStartDate() { 
        TS ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRC-11: "Effective Start Date" - creates it if necessary
     */
    public TS getPrc11_EffectiveStartDate() { 
        TS ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRC-12: "Effective End Date" - creates it if necessary
     */
    public TS getEffectiveEndDate() { 
        TS ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRC-12: "Effective End Date" - creates it if necessary
     */
    public TS getPrc12_EffectiveEndDate() { 
        TS ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRC-13: "Price Override Flag" - creates it if necessary
     */
    public IS getPriceOverrideFlag() { 
        IS ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRC-13: "Price Override Flag" - creates it if necessary
     */
    public IS getPrc13_PriceOverrideFlag() { 
        IS ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Billing Category (PRC-14).
     */
    public CE[] getBillingCategory() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(14);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRC-14: "Billing Category" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getBillingCategory(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRC-14: "Billing Category" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getPrc14_BillingCategory(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(14, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PRC-14: "Billing Category" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertBillingCategory(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(14, rep);
    }



    /**
     * Inserts a repetition of
     * PRC-14: "Billing Category" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertPrc14_BillingCategory(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(14, rep);
    }


    /**
     * Removes a repetition of
     * PRC-14: "Billing Category" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeBillingCategory(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(14, rep);
    }


    /**
     * Removes a repetition of
     * PRC-14: "Billing Category" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removePrc14_BillingCategory(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(14, rep);
    }




    /**
     * Returns
     * PRC-15: "Chargeable Flag" - creates it if necessary
     */
    public ID getChargeableFlag() { 
        ID ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRC-15: "Chargeable Flag" - creates it if necessary
     */
    public ID getPrc15_ChargeableFlag() { 
        ID ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRC-16: "Active/Inactive Flag" - creates it if necessary
     */
    public ID getActiveInactiveFlag() { 
        ID ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRC-16: "Active/Inactive Flag" - creates it if necessary
     */
    public ID getPrc16_ActiveInactiveFlag() { 
        ID ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRC-17: "Cost" - creates it if necessary
     */
    public MO getCost() { 
        MO ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (MO)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRC-17: "Cost" - creates it if necessary
     */
    public MO getPrc17_Cost() { 
        MO ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (MO)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRC-18: "Charge On Indicator" - creates it if necessary
     */
    public IS getChargeOnIndicator() { 
        IS ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRC-18: "Charge On Indicator" - creates it if necessary
     */
    public IS getPrc18_ChargeOnIndicator() { 
        IS ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new CE(getMessage());
          case 1: return new CE(getMessage());
          case 2: return new CE(getMessage());
          case 3: return new IS(getMessage(), new Integer( 4 ));
          case 4: return new CP(getMessage());
          case 5: return new ST(getMessage());
          case 6: return new NM(getMessage());
          case 7: return new NM(getMessage());
          case 8: return new MO(getMessage());
          case 9: return new MO(getMessage());
          case 10: return new TS(getMessage());
          case 11: return new TS(getMessage());
          case 12: return new IS(getMessage(), new Integer( 268 ));
          case 13: return new CE(getMessage());
          case 14: return new ID(getMessage(), new Integer( 136 ));
          case 15: return new ID(getMessage(), new Integer( 183 ));
          case 16: return new MO(getMessage());
          case 17: return new IS(getMessage(), new Integer( 269 ));
          default: return null;
       }
   }


}

