/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v251.segment;

// import ca.uhn.hl7v2.model.v251.group.*;
import ca.uhn.hl7v2.model.v251.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 TQ2 message segment (Timing/Quantity Relationship). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>TQ2-1: Set ID - TQ2 (SI) <b>optional </b>
     * <li>TQ2-2: Sequence/Results Flag (ID) <b>optional </b>
     * <li>TQ2-3: Related Placer Number (EI) <b>optional repeating</b>
     * <li>TQ2-4: Related Filler Number (EI) <b>optional repeating</b>
     * <li>TQ2-5: Related Placer Group Number (EI) <b>optional repeating</b>
     * <li>TQ2-6: Sequence Condition Code (ID) <b>optional </b>
     * <li>TQ2-7: Cyclic Entry/Exit Indicator (ID) <b>optional </b>
     * <li>TQ2-8: Sequence Condition Time Interval (CQ) <b>optional </b>
     * <li>TQ2-9: Cyclic Group Maximum Number of Repeats (NM) <b>optional </b>
     * <li>TQ2-10: Special Service Request Relationship (ID) <b>optional </b>
 * </ul>
 */
public class TQ2 extends AbstractSegment {

    /** 
     * Creates a new TQ2 segment
     */
    public TQ2(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Set ID - TQ2");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Sequence/Results Flag");
                                  this.add(EI.class, false, 0, 22, new Object[]{ getMessage(), new Integer(0) }, "Related Placer Number");
                                  this.add(EI.class, false, 0, 22, new Object[]{ getMessage(), new Integer(0) }, "Related Filler Number");
                                  this.add(EI.class, false, 0, 22, new Object[]{ getMessage(), new Integer(0) }, "Related Placer Group Number");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "Sequence Condition Code");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Cyclic Entry/Exit Indicator");
                                  this.add(CQ.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Sequence Condition Time Interval");
                                  this.add(NM.class, false, 1, 10, new Object[]{ getMessage(), new Integer(0) }, "Cyclic Group Maximum Number of Repeats");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Special Service Request Relationship");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating TQ2 - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * TQ2-1: "Set ID - TQ2" - creates it if necessary
     */
    public SI getSetIDTQ2() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TQ2-1: "Set ID - TQ2" - creates it if necessary
     */
    public SI getTq21_SetIDTQ2() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TQ2-2: "Sequence/Results Flag" - creates it if necessary
     */
    public ID getSequenceResultsFlag() { 
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TQ2-2: "Sequence/Results Flag" - creates it if necessary
     */
    public ID getTq22_SequenceResultsFlag() { 
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Related Placer Number (TQ2-3).
     */
    public EI[] getRelatedPlacerNumber() {
        EI[] ret = null;
        try {
            Type[] t = this.getField(3);  
            ret = new EI[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (EI)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * TQ2-3: "Related Placer Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public EI getRelatedPlacerNumber(int rep) { 
        EI ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * TQ2-3: "Related Placer Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public EI getTq23_RelatedPlacerNumber(int rep) { 
        EI ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * TQ2-3: "Related Placer Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public EI insertRelatedPlacerNumber(int rep) throws HL7Exception { 
        return (EI) super.insertRepetition(3, rep);
    }



    /**
     * Inserts a repetition of
     * TQ2-3: "Related Placer Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public EI insertTq23_RelatedPlacerNumber(int rep) throws HL7Exception { 
        return (EI) super.insertRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * TQ2-3: "Related Placer Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public EI removeRelatedPlacerNumber(int rep) throws HL7Exception { 
        return (EI) super.removeRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * TQ2-3: "Related Placer Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public EI removeTq23_RelatedPlacerNumber(int rep) throws HL7Exception { 
        return (EI) super.removeRepetition(3, rep);
    }



    /**
     * Returns all repetitions of Related Filler Number (TQ2-4).
     */
    public EI[] getRelatedFillerNumber() {
        EI[] ret = null;
        try {
            Type[] t = this.getField(4);  
            ret = new EI[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (EI)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * TQ2-4: "Related Filler Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public EI getRelatedFillerNumber(int rep) { 
        EI ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * TQ2-4: "Related Filler Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public EI getTq24_RelatedFillerNumber(int rep) { 
        EI ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * TQ2-4: "Related Filler Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public EI insertRelatedFillerNumber(int rep) throws HL7Exception { 
        return (EI) super.insertRepetition(4, rep);
    }



    /**
     * Inserts a repetition of
     * TQ2-4: "Related Filler Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public EI insertTq24_RelatedFillerNumber(int rep) throws HL7Exception { 
        return (EI) super.insertRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * TQ2-4: "Related Filler Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public EI removeRelatedFillerNumber(int rep) throws HL7Exception { 
        return (EI) super.removeRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * TQ2-4: "Related Filler Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public EI removeTq24_RelatedFillerNumber(int rep) throws HL7Exception { 
        return (EI) super.removeRepetition(4, rep);
    }



    /**
     * Returns all repetitions of Related Placer Group Number (TQ2-5).
     */
    public EI[] getRelatedPlacerGroupNumber() {
        EI[] ret = null;
        try {
            Type[] t = this.getField(5);  
            ret = new EI[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (EI)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * TQ2-5: "Related Placer Group Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public EI getRelatedPlacerGroupNumber(int rep) { 
        EI ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * TQ2-5: "Related Placer Group Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public EI getTq25_RelatedPlacerGroupNumber(int rep) { 
        EI ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * TQ2-5: "Related Placer Group Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public EI insertRelatedPlacerGroupNumber(int rep) throws HL7Exception { 
        return (EI) super.insertRepetition(5, rep);
    }



    /**
     * Inserts a repetition of
     * TQ2-5: "Related Placer Group Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public EI insertTq25_RelatedPlacerGroupNumber(int rep) throws HL7Exception { 
        return (EI) super.insertRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * TQ2-5: "Related Placer Group Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public EI removeRelatedPlacerGroupNumber(int rep) throws HL7Exception { 
        return (EI) super.removeRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * TQ2-5: "Related Placer Group Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public EI removeTq25_RelatedPlacerGroupNumber(int rep) throws HL7Exception { 
        return (EI) super.removeRepetition(5, rep);
    }




    /**
     * Returns
     * TQ2-6: "Sequence Condition Code" - creates it if necessary
     */
    public ID getSequenceConditionCode() { 
        ID ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TQ2-6: "Sequence Condition Code" - creates it if necessary
     */
    public ID getTq26_SequenceConditionCode() { 
        ID ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TQ2-7: "Cyclic Entry/Exit Indicator" - creates it if necessary
     */
    public ID getCyclicEntryExitIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TQ2-7: "Cyclic Entry/Exit Indicator" - creates it if necessary
     */
    public ID getTq27_CyclicEntryExitIndicator() { 
        ID ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TQ2-8: "Sequence Condition Time Interval" - creates it if necessary
     */
    public CQ getSequenceConditionTimeInterval() { 
        CQ ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TQ2-8: "Sequence Condition Time Interval" - creates it if necessary
     */
    public CQ getTq28_SequenceConditionTimeInterval() { 
        CQ ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TQ2-9: "Cyclic Group Maximum Number of Repeats" - creates it if necessary
     */
    public NM getCyclicGroupMaximumNumberOfRepeats() { 
        NM ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TQ2-9: "Cyclic Group Maximum Number of Repeats" - creates it if necessary
     */
    public NM getTq29_CyclicGroupMaximumNumberOfRepeats() { 
        NM ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * TQ2-10: "Special Service Request Relationship" - creates it if necessary
     */
    public ID getSpecialServiceRequestRelationship() { 
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * TQ2-10: "Special Service Request Relationship" - creates it if necessary
     */
    public ID getTq210_SpecialServiceRequestRelationship() { 
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new ID(getMessage(), new Integer( 503 ));
          case 2: return new EI(getMessage());
          case 3: return new EI(getMessage());
          case 4: return new EI(getMessage());
          case 5: return new ID(getMessage(), new Integer( 504 ));
          case 6: return new ID(getMessage(), new Integer( 505 ));
          case 7: return new CQ(getMessage());
          case 8: return new NM(getMessage());
          case 9: return new ID(getMessage(), new Integer( 506 ));
          default: return null;
       }
   }


}

