/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v251.segment.SPM;
import ca.uhn.hl7v2.model.v251.segment.TCC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class TCU_U10_TEST_CONFIGURATION
extends AbstractGroup {
    public TCU_U10_TEST_CONFIGURATION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SPM.class, false, false);
            this.add(TCC.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating TCU_U10_TEST_CONFIGURATION - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public SPM getSPM() {
        SPM ret = null;
        try {
            ret = (SPM)this.get("SPM");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TCC getTCC() {
        TCC ret = null;
        try {
            ret = (TCC)this.get("TCC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TCC getTCC(int rep) {
        TCC ret = null;
        try {
            ret = (TCC)this.get("TCC", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getTCCReps() {
        int reps = -1;
        try {
            reps = this.getAll("TCC").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertTCC(TCC structure, int rep) throws HL7Exception {
        super.insertRepetition("TCC", (Structure)structure, rep);
    }

    public TCC insertTCC(int rep) throws HL7Exception {
        return (TCC)super.insertRepetition("TCC", rep);
    }

    public TCC removeTCC(int rep) throws HL7Exception {
        return (TCC)super.removeRepetition("TCC", rep);
    }
}

