/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v251.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 RFR (Reference Range) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Numeric Range (NR)
 * <li>Administrative Sex (IS)
 * <li>Age Range (NR)
 * <li>Gestational Age Range (NR)
 * <li>Species (ST)
 * <li>Race/subspecies (ST)
 * <li>Conditions (TX)
 * </ul>
 */
public class RFR extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new RFR type
     */
    public RFR(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[7];    
        data[0] = new NR(getMessage());
        data[1] = new IS(getMessage(), 1);
        data[2] = new NR(getMessage());
        data[3] = new NR(getMessage());
        data[4] = new ST(getMessage());
        data[5] = new ST(getMessage());
        data[6] = new TX(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Numeric Range (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NR getNumericRange() {
       NR ret = null;
       try {
          ret = (NR)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Numeric Range (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NR getRfr1_NumericRange() {
       NR ret = null;
       try {
          ret = (NR)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Administrative Sex (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getAdministrativeSex() {
       IS ret = null;
       try {
          ret = (IS)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Administrative Sex (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getRfr2_AdministrativeSex() {
       IS ret = null;
       try {
          ret = (IS)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Age Range (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NR getAgeRange() {
       NR ret = null;
       try {
          ret = (NR)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Age Range (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NR getRfr3_AgeRange() {
       NR ret = null;
       try {
          ret = (NR)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Gestational Age Range (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NR getGestationalAgeRange() {
       NR ret = null;
       try {
          ret = (NR)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Gestational Age Range (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NR getRfr4_GestationalAgeRange() {
       NR ret = null;
       try {
          ret = (NR)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Species (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getSpecies() {
       ST ret = null;
       try {
          ret = (ST)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Species (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getRfr5_Species() {
       ST ret = null;
       try {
          ret = (ST)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Race/subspecies (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getRaceSubspecies() {
       ST ret = null;
       try {
          ret = (ST)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Race/subspecies (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getRfr6_RaceSubspecies() {
       ST ret = null;
       try {
          ret = (ST)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Conditions (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TX getConditions() {
       TX ret = null;
       try {
          ret = (TX)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Conditions (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TX getRfr7_Conditions() {
       TX ret = null;
       try {
          ret = (TX)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

