/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v251.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 RMC (Room Coverage) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Room Type (IS)
 * <li>Amount Type (IS)
 * <li>Coverage Amount (NM)
 * <li>Money or Percentage (MOP)
 * </ul>
 */
public class RMC extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new RMC type
     */
    public RMC(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[4];    
        data[0] = new IS(getMessage(), 145);
        data[1] = new IS(getMessage(), 146);
        data[2] = new NM(getMessage());
        data[3] = new MOP(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Room Type (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getRoomType() {
       IS ret = null;
       try {
          ret = (IS)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Room Type (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getRmc1_RoomType() {
       IS ret = null;
       try {
          ret = (IS)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Amount Type (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getAmountType() {
       IS ret = null;
       try {
          ret = (IS)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Amount Type (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getRmc2_AmountType() {
       IS ret = null;
       try {
          ret = (IS)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Coverage Amount (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getCoverageAmount() {
       NM ret = null;
       try {
          ret = (NM)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Coverage Amount (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getRmc3_CoverageAmount() {
       NM ret = null;
       try {
          ret = (NM)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Money or Percentage (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public MOP getMoneyOrPercentage() {
       MOP ret = null;
       try {
          ret = (MOP)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Money or Percentage (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public MOP getRmc4_MoneyOrPercentage() {
       MOP ret = null;
       try {
          ret = (MOP)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

