/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v251.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 SPS (Specimen Source) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>Specimen Source Name or Code (CWE)
 * <li>Additives (CWE)
 * <li>Specimen Collection Method (TX)
 * <li>Body Site (CWE)
 * <li>Site Modifier (CWE)
 * <li>Collection Method Modifier Code (CWE)
 * <li>Specimen Role (CWE)
 * </ul>
 */
public class SPS extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new SPS type
     */
    public SPS(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[7];    
        data[0] = new CWE(getMessage());
        data[1] = new CWE(getMessage());
        data[2] = new TX(getMessage());
        data[3] = new CWE(getMessage());
        data[4] = new CWE(getMessage());
        data[5] = new CWE(getMessage());
        data[6] = new CWE(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns Specimen Source Name or Code (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CWE getSpecimenSourceNameOrCode() {
       CWE ret = null;
       try {
          ret = (CWE)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Specimen Source Name or Code (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CWE getSps1_SpecimenSourceNameOrCode() {
       CWE ret = null;
       try {
          ret = (CWE)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Additives (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CWE getAdditives() {
       CWE ret = null;
       try {
          ret = (CWE)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Additives (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CWE getSps2_Additives() {
       CWE ret = null;
       try {
          ret = (CWE)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Specimen Collection Method (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TX getSpecimenCollectionMethod() {
       TX ret = null;
       try {
          ret = (TX)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Specimen Collection Method (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TX getSps3_SpecimenCollectionMethod() {
       TX ret = null;
       try {
          ret = (TX)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Body Site (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CWE getBodySite() {
       CWE ret = null;
       try {
          ret = (CWE)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Body Site (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CWE getSps4_BodySite() {
       CWE ret = null;
       try {
          ret = (CWE)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Site Modifier (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CWE getSiteModifier() {
       CWE ret = null;
       try {
          ret = (CWE)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Site Modifier (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CWE getSps5_SiteModifier() {
       CWE ret = null;
       try {
          ret = (CWE)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Collection Method Modifier Code (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CWE getCollectionMethodModifierCode() {
       CWE ret = null;
       try {
          ret = (CWE)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Collection Method Modifier Code (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CWE getSps6_CollectionMethodModifierCode() {
       CWE ret = null;
       try {
          ret = (CWE)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Specimen Role (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CWE getSpecimenRole() {
       CWE ret = null;
       try {
          ret = (CWE)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Specimen Role (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CWE getSps7_SpecimenRole() {
       CWE ret = null;
       try {
          ret = (CWE)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

