/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v251.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 XCN (Extended Composite ID Number and Name for Persons) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>ID Number (ST)
 * <li>Family Name (FN)
 * <li>Given Name (ST)
 * <li>Second and Further Given Names or Initials Thereof (ST)
 * <li>Suffix (e.g., JR or III) (ST)
 * <li>Prefix (e.g., DR) (ST)
 * <li>Degree (e.g., MD) (IS)
 * <li>Source Table (IS)
 * <li>Assigning Authority (HD)
 * <li>Name Type Code (ID)
 * <li>Identifier Check Digit (ST)
 * <li>Check Digit Scheme (ID)
 * <li>Identifier Type Code (ID)
 * <li>Assigning Facility (HD)
 * <li>Name Representation Code (ID)
 * <li>Name Context (CE)
 * <li>Name Validity Range (DR)
 * <li>Name Assembly Order (ID)
 * <li>Effective Date (TS)
 * <li>Expiration Date (TS)
 * <li>Professional Suffix (ST)
 * <li>Assigning Jurisdiction (CWE)
 * <li>Assigning Agency or Department (CWE)
 * </ul>
 */
public class XCN extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new XCN type
     */
    public XCN(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[23];    
        data[0] = new ST(getMessage());
        data[1] = new FN(getMessage());
        data[2] = new ST(getMessage());
        data[3] = new ST(getMessage());
        data[4] = new ST(getMessage());
        data[5] = new ST(getMessage());
        data[6] = new IS(getMessage(), 360);
        data[7] = new IS(getMessage(), 297);
        data[8] = new HD(getMessage());
        data[9] = new ID(getMessage(), 200);
        data[10] = new ST(getMessage());
        data[11] = new ID(getMessage(), 61);
        data[12] = new ID(getMessage(), 203);
        data[13] = new HD(getMessage());
        data[14] = new ID(getMessage(), 465);
        data[15] = new CE(getMessage());
        data[16] = new DR(getMessage());
        data[17] = new ID(getMessage(), 444);
        data[18] = new TS(getMessage());
        data[19] = new TS(getMessage());
        data[20] = new ST(getMessage());
        data[21] = new CWE(getMessage());
        data[22] = new CWE(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns ID Number (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getIDNumber() {
       ST ret = null;
       try {
          ret = (ST)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns ID Number (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getXcn1_IDNumber() {
       ST ret = null;
       try {
          ret = (ST)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Family Name (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public FN getFamilyName() {
       FN ret = null;
       try {
          ret = (FN)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Family Name (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public FN getXcn2_FamilyName() {
       FN ret = null;
       try {
          ret = (FN)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Given Name (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getGivenName() {
       ST ret = null;
       try {
          ret = (ST)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Given Name (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getXcn3_GivenName() {
       ST ret = null;
       try {
          ret = (ST)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Second and Further Given Names or Initials Thereof (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getSecondAndFurtherGivenNamesOrInitialsThereof() {
       ST ret = null;
       try {
          ret = (ST)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Second and Further Given Names or Initials Thereof (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getXcn4_SecondAndFurtherGivenNamesOrInitialsThereof() {
       ST ret = null;
       try {
          ret = (ST)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Suffix (e.g., JR or III) (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getSuffixEgJRorIII() {
       ST ret = null;
       try {
          ret = (ST)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Suffix (e.g., JR or III) (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getXcn5_SuffixEgJRorIII() {
       ST ret = null;
       try {
          ret = (ST)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Prefix (e.g., DR) (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getPrefixEgDR() {
       ST ret = null;
       try {
          ret = (ST)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Prefix (e.g., DR) (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getXcn6_PrefixEgDR() {
       ST ret = null;
       try {
          ret = (ST)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Degree (e.g., MD) (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getDegreeEgMD() {
       IS ret = null;
       try {
          ret = (IS)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Degree (e.g., MD) (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getXcn7_DegreeEgMD() {
       IS ret = null;
       try {
          ret = (IS)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Source Table (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getSourceTable() {
       IS ret = null;
       try {
          ret = (IS)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Source Table (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public IS getXcn8_SourceTable() {
       IS ret = null;
       try {
          ret = (IS)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Assigning Authority (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public HD getAssigningAuthority() {
       HD ret = null;
       try {
          ret = (HD)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Assigning Authority (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public HD getXcn9_AssigningAuthority() {
       HD ret = null;
       try {
          ret = (HD)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Name Type Code (component #10).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getNameTypeCode() {
       ID ret = null;
       try {
          ret = (ID)getComponent(9);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Name Type Code (component #10).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getXcn10_NameTypeCode() {
       ID ret = null;
       try {
          ret = (ID)getComponent(9);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Identifier Check Digit (component #11).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getIdentifierCheckDigit() {
       ST ret = null;
       try {
          ret = (ST)getComponent(10);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Identifier Check Digit (component #11).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getXcn11_IdentifierCheckDigit() {
       ST ret = null;
       try {
          ret = (ST)getComponent(10);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Check Digit Scheme (component #12).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCheckDigitScheme() {
       ID ret = null;
       try {
          ret = (ID)getComponent(11);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Check Digit Scheme (component #12).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getXcn12_CheckDigitScheme() {
       ID ret = null;
       try {
          ret = (ID)getComponent(11);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Identifier Type Code (component #13).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getIdentifierTypeCode() {
       ID ret = null;
       try {
          ret = (ID)getComponent(12);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Identifier Type Code (component #13).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getXcn13_IdentifierTypeCode() {
       ID ret = null;
       try {
          ret = (ID)getComponent(12);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Assigning Facility (component #14).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public HD getAssigningFacility() {
       HD ret = null;
       try {
          ret = (HD)getComponent(13);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Assigning Facility (component #14).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public HD getXcn14_AssigningFacility() {
       HD ret = null;
       try {
          ret = (HD)getComponent(13);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Name Representation Code (component #15).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getNameRepresentationCode() {
       ID ret = null;
       try {
          ret = (ID)getComponent(14);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Name Representation Code (component #15).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getXcn15_NameRepresentationCode() {
       ID ret = null;
       try {
          ret = (ID)getComponent(14);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Name Context (component #16).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getNameContext() {
       CE ret = null;
       try {
          ret = (CE)getComponent(15);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Name Context (component #16).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getXcn16_NameContext() {
       CE ret = null;
       try {
          ret = (CE)getComponent(15);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Name Validity Range (component #17).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public DR getNameValidityRange() {
       DR ret = null;
       try {
          ret = (DR)getComponent(16);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Name Validity Range (component #17).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public DR getXcn17_NameValidityRange() {
       DR ret = null;
       try {
          ret = (DR)getComponent(16);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Name Assembly Order (component #18).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getNameAssemblyOrder() {
       ID ret = null;
       try {
          ret = (ID)getComponent(17);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Name Assembly Order (component #18).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getXcn18_NameAssemblyOrder() {
       ID ret = null;
       try {
          ret = (ID)getComponent(17);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Effective Date (component #19).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TS getEffectiveDate() {
       TS ret = null;
       try {
          ret = (TS)getComponent(18);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Effective Date (component #19).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TS getXcn19_EffectiveDate() {
       TS ret = null;
       try {
          ret = (TS)getComponent(18);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Expiration Date (component #20).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TS getExpirationDate() {
       TS ret = null;
       try {
          ret = (TS)getComponent(19);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Expiration Date (component #20).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TS getXcn20_ExpirationDate() {
       TS ret = null;
       try {
          ret = (TS)getComponent(19);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Professional Suffix (component #21).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getProfessionalSuffix() {
       ST ret = null;
       try {
          ret = (ST)getComponent(20);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Professional Suffix (component #21).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getXcn21_ProfessionalSuffix() {
       ST ret = null;
       try {
          ret = (ST)getComponent(20);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Assigning Jurisdiction (component #22).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CWE getAssigningJurisdiction() {
       CWE ret = null;
       try {
          ret = (CWE)getComponent(21);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Assigning Jurisdiction (component #22).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CWE getXcn22_AssigningJurisdiction() {
       CWE ret = null;
       try {
          ret = (CWE)getComponent(21);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Assigning Agency or Department (component #23).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CWE getAssigningAgencyOrDepartment() {
       CWE ret = null;
       try {
          ret = (CWE)getComponent(22);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Assigning Agency or Department (component #23).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CWE getXcn23_AssigningAgencyOrDepartment() {
       CWE ret = null;
       try {
          ret = (CWE)getComponent(22);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

