/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.model.v251.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a ADT_A03_INSURANCE group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: IN1 (Insurance) <b> </b></li>
                 * <li>2: IN2 (Insurance Additional Information) <b>optional </b></li>
                 * <li>3: IN3 (Insurance Additional Information, Certification) <b>optional repeating</b></li>
                 * <li>4: ROL (Role) <b>optional repeating</b></li>
 * </ul>
 */
public class ADT_A03_INSURANCE extends AbstractGroup {

    /** 
     * Creates a new ADT_A03_INSURANCE group
     */
    public ADT_A03_INSURANCE(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(IN1.class, true, false);
                          this.add(IN2.class, false, false);
                          this.add(IN3.class, false, true);
                          this.add(ROL.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ADT_A03_INSURANCE - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.5.1"
     */
    public String getVersion() {
       return "2.5.1";
    }



    /**
     * Returns
     * IN1 (Insurance) - creates it if necessary
     */
    public IN1 getIN1() { 
       IN1 ret = null;
       try {
          ret = (IN1)this.get("IN1");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * IN2 (Insurance Additional Information) - creates it if necessary
     */
    public IN2 getIN2() { 
       IN2 ret = null;
       try {
          ret = (IN2)this.get("IN2");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * IN3 (Insurance Additional Information, Certification) - creates it if necessary
     */
    public IN3 getIN3() { 
       IN3 ret = null;
       try {
          ret = (IN3)this.get("IN3");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * IN3 (Insurance Additional Information, Certification) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public IN3 getIN3(int rep) { 
       IN3 ret = null;
       try {
          ret = (IN3)this.get("IN3", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of IN3 
     */ 
    public int getIN3Reps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("IN3").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of IN3 (Insurance Additional Information, Certification)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertIN3(IN3 structure, int rep) throws HL7Exception { 
       super.insertRepetition("IN3", structure, rep);
    }


    /**
     * Inserts a specific repetition of IN3 (Insurance Additional Information, Certification)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public IN3 insertIN3(int rep) throws HL7Exception { 
       return (IN3)super.insertRepetition("IN3", rep);
    }


    /**
     * Removes a specific repetition of IN3 (Insurance Additional Information, Certification)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public IN3 removeIN3(int rep) throws HL7Exception { 
       return (IN3)super.removeRepetition("IN3", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * ROL (Role) - creates it if necessary
     */
    public ROL getROL() { 
       ROL ret = null;
       try {
          ret = (ROL)this.get("ROL");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ROL (Role) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ROL getROL(int rep) { 
       ROL ret = null;
       try {
          ret = (ROL)this.get("ROL", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ROL 
     */ 
    public int getROLReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ROL").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ROL (Role)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertROL(ROL structure, int rep) throws HL7Exception { 
       super.insertRepetition("ROL", structure, rep);
    }


    /**
     * Inserts a specific repetition of ROL (Role)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public ROL insertROL(int rep) throws HL7Exception { 
       return (ROL)super.insertRepetition("ROL", rep);
    }


    /**
     * Removes a specific repetition of ROL (Role)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public ROL removeROL(int rep) throws HL7Exception { 
       return (ROL)super.removeRepetition("ROL", rep);
    }



}

