/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.model.v251.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a CSU_C09_STUDY_PHARM group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: ORC (Common Order) <b>optional </b></li>
                 * <li>2: CSU_C09_RX_ADMIN (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class CSU_C09_STUDY_PHARM extends AbstractGroup {

    /** 
     * Creates a new CSU_C09_STUDY_PHARM group
     */
    public CSU_C09_STUDY_PHARM(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(ORC.class, false, false);
                          this.add(CSU_C09_RX_ADMIN.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating CSU_C09_STUDY_PHARM - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.5.1"
     */
    public String getVersion() {
       return "2.5.1";
    }



    /**
     * Returns
     * ORC (Common Order) - creates it if necessary
     */
    public ORC getORC() { 
       ORC ret = null;
       try {
          ret = (ORC)this.get("ORC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * RX_ADMIN (a Group object) - creates it if necessary
     */
    public CSU_C09_RX_ADMIN getRX_ADMIN() { 
       CSU_C09_RX_ADMIN ret = null;
       try {
          ret = (CSU_C09_RX_ADMIN)this.get("RX_ADMIN");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * RX_ADMIN (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public CSU_C09_RX_ADMIN getRX_ADMIN(int rep) { 
       CSU_C09_RX_ADMIN ret = null;
       try {
          ret = (CSU_C09_RX_ADMIN)this.get("RX_ADMIN", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of RX_ADMIN 
     */ 
    public int getRX_ADMINReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("RX_ADMIN").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of RX_ADMIN (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertRX_ADMIN(CSU_C09_RX_ADMIN structure, int rep) throws HL7Exception { 
       super.insertRepetition("RX_ADMIN", structure, rep);
    }


    /**
     * Inserts a specific repetition of RX_ADMIN (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public CSU_C09_RX_ADMIN insertRX_ADMIN(int rep) throws HL7Exception { 
       return (CSU_C09_RX_ADMIN)super.insertRepetition("RX_ADMIN", rep);
    }


    /**
     * Removes a specific repetition of RX_ADMIN (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public CSU_C09_RX_ADMIN removeRX_ADMIN(int rep) throws HL7Exception { 
       return (CSU_C09_RX_ADMIN)super.removeRepetition("RX_ADMIN", rep);
    }



}

