/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.model.v251.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a RGV_O15_ORDER_DETAIL group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: RXO (Pharmacy/Treatment Order) <b> </b></li>
                 * <li>2: RGV_O15_ORDER_DETAIL_SUPPLEMENT (a Group object) <b>optional </b></li>
 * </ul>
 */
public class RGV_O15_ORDER_DETAIL extends AbstractGroup {

    /** 
     * Creates a new RGV_O15_ORDER_DETAIL group
     */
    public RGV_O15_ORDER_DETAIL(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(RXO.class, true, false);
                          this.add(RGV_O15_ORDER_DETAIL_SUPPLEMENT.class, false, false);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RGV_O15_ORDER_DETAIL - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.5.1"
     */
    public String getVersion() {
       return "2.5.1";
    }



    /**
     * Returns
     * RXO (Pharmacy/Treatment Order) - creates it if necessary
     */
    public RXO getRXO() { 
       RXO ret = null;
       try {
          ret = (RXO)this.get("RXO");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * ORDER_DETAIL_SUPPLEMENT (a Group object) - creates it if necessary
     */
    public RGV_O15_ORDER_DETAIL_SUPPLEMENT getORDER_DETAIL_SUPPLEMENT() { 
       RGV_O15_ORDER_DETAIL_SUPPLEMENT ret = null;
       try {
          ret = (RGV_O15_ORDER_DETAIL_SUPPLEMENT)this.get("ORDER_DETAIL_SUPPLEMENT");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




}

