/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.model.v251.group.*;
import ca.uhn.hl7v2.model.v251.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a ROR_ROR message structure (see chapter 4.13.15). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (Message Header) <b> </b></li>
                 * <li>2: MSA (Message Acknowledgment) <b> </b></li>
                 * <li>3: ERR (Error) <b>optional repeating</b></li>
                 * <li>4: SFT (Software Segment) <b>optional repeating</b></li>
                 * <li>5: ROR_ROR_DEFINITION (a Group object) <b> repeating</b></li>
                 * <li>6: DSC (Continuation Pointer) <b>optional </b></li>
 * </ul>
 */
public class ROR_ROR extends AbstractMessage  {

    /**
     * Creates a new ROR_ROR message with DefaultModelClassFactory. 
     */ 
    public ROR_ROR() { 
       this(new DefaultModelClassFactory());
    }

    /** 
     * Creates a new ROR_ROR message with custom ModelClassFactory.
     */
    public ROR_ROR(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(MSA.class, true, false);
                          this.add(ERR.class, false, true);
                          this.add(SFT.class, false, true);
                          this.add(ROR_ROR_DEFINITION.class, true, true);
                          this.add(DSC.class, false, false);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ROR_ROR - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.5.1"
     */
    public String getVersion() {
       return "2.5.1";
    }



    /**
     * Returns
     * MSH (Message Header) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * MSA (Message Acknowledgment) - creates it if necessary
     */
    public MSA getMSA() { 
       MSA ret = null;
       try {
          ret = (MSA)this.get("MSA");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * ERR (Error) - creates it if necessary
     */
    public ERR getERR() { 
       ERR ret = null;
       try {
          ret = (ERR)this.get("ERR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ERR (Error) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ERR getERR(int rep) { 
       ERR ret = null;
       try {
          ret = (ERR)this.get("ERR", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ERR 
     */ 
    public int getERRReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ERR").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ERR (Error)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertERR(ERR structure, int rep) throws HL7Exception { 
       super.insertRepetition( "ERR", structure, rep);
    }


    /**
     * Inserts a specific repetition of ERR (Error)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public ERR insertERR(int rep) throws HL7Exception { 
       return (ERR)super.insertRepetition("ERR", rep);
    }


    /**
     * Removes a specific repetition of ERR (Error)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public ERR removeERR(int rep) throws HL7Exception { 
       return (ERR)super.removeRepetition("ERR", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * SFT (Software Segment) - creates it if necessary
     */
    public SFT getSFT() { 
       SFT ret = null;
       try {
          ret = (SFT)this.get("SFT");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * SFT (Software Segment) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public SFT getSFT(int rep) { 
       SFT ret = null;
       try {
          ret = (SFT)this.get("SFT", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of SFT 
     */ 
    public int getSFTReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("SFT").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of SFT (Software Segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertSFT(SFT structure, int rep) throws HL7Exception { 
       super.insertRepetition( "SFT", structure, rep);
    }


    /**
     * Inserts a specific repetition of SFT (Software Segment)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public SFT insertSFT(int rep) throws HL7Exception { 
       return (SFT)super.insertRepetition("SFT", rep);
    }


    /**
     * Removes a specific repetition of SFT (Software Segment)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public SFT removeSFT(int rep) throws HL7Exception { 
       return (SFT)super.removeRepetition("SFT", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * DEFINITION (a Group object) - creates it if necessary
     */
    public ROR_ROR_DEFINITION getDEFINITION() { 
       ROR_ROR_DEFINITION ret = null;
       try {
          ret = (ROR_ROR_DEFINITION)this.get("DEFINITION");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * DEFINITION (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ROR_ROR_DEFINITION getDEFINITION(int rep) { 
       ROR_ROR_DEFINITION ret = null;
       try {
          ret = (ROR_ROR_DEFINITION)this.get("DEFINITION", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of DEFINITION 
     */ 
    public int getDEFINITIONReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("DEFINITION").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of DEFINITION (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertDEFINITION(ROR_ROR_DEFINITION structure, int rep) throws HL7Exception { 
       super.insertRepetition( "DEFINITION", structure, rep);
    }


    /**
     * Inserts a specific repetition of DEFINITION (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public ROR_ROR_DEFINITION insertDEFINITION(int rep) throws HL7Exception { 
       return (ROR_ROR_DEFINITION)super.insertRepetition("DEFINITION", rep);
    }


    /**
     * Removes a specific repetition of DEFINITION (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public ROR_ROR_DEFINITION removeDEFINITION(int rep) throws HL7Exception { 
       return (ROR_ROR_DEFINITION)super.removeRepetition("DEFINITION", rep);
    }



    /**
     * Returns
     * DSC (Continuation Pointer) - creates it if necessary
     */
    public DSC getDSC() { 
       DSC ret = null;
       try {
          ret = (DSC)this.get("DSC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




}

