/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v251.segment;

// import ca.uhn.hl7v2.model.v251.group.*;
import ca.uhn.hl7v2.model.v251.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 AFF message segment (Professional Affiliation). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>AFF-1: Set ID - AFF (SI) <b> </b>
     * <li>AFF-2: Professional Organization (XON) <b> </b>
     * <li>AFF-3: Professional Organization Address (XAD) <b>optional </b>
     * <li>AFF-4: Professional Organization Affiliation Date Range (DR) <b>optional repeating</b>
     * <li>AFF-5: Professional Affiliation Additional Information (ST) <b>optional </b>
 * </ul>
 */
public class AFF extends AbstractSegment {

    /** 
     * Creates a new AFF segment
     */
    public AFF(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, true, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Set ID - AFF");
                                  this.add(XON.class, true, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Professional Organization");
                                  this.add(XAD.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Professional Organization Address");
                                  this.add(DR.class, false, 0, 52, new Object[]{ getMessage(), new Integer(0) }, "Professional Organization Affiliation Date Range");
                                  this.add(ST.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Professional Affiliation Additional Information");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating AFF - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * AFF-1: "Set ID - AFF" - creates it if necessary
     */
    public SI getSetIDAFF() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * AFF-1: "Set ID - AFF" - creates it if necessary
     */
    public SI getAff1_SetIDAFF() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * AFF-2: "Professional Organization" - creates it if necessary
     */
    public XON getProfessionalOrganization() { 
        XON ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * AFF-2: "Professional Organization" - creates it if necessary
     */
    public XON getAff2_ProfessionalOrganization() { 
        XON ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * AFF-3: "Professional Organization Address" - creates it if necessary
     */
    public XAD getProfessionalOrganizationAddress() { 
        XAD ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * AFF-3: "Professional Organization Address" - creates it if necessary
     */
    public XAD getAff3_ProfessionalOrganizationAddress() { 
        XAD ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Professional Organization Affiliation Date Range (AFF-4).
     */
    public DR[] getProfessionalOrganizationAffiliationDateRange() {
        DR[] ret = null;
        try {
            Type[] t = this.getField(4);  
            ret = new DR[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (DR)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Professional Organization Affiliation Date Range (AFF-4).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getProfessionalOrganizationAffiliationDateRangeReps() {
        DR[] ret = null;
        try {
            Type[] t = this.getField(4);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * AFF-4: "Professional Organization Affiliation Date Range" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public DR getProfessionalOrganizationAffiliationDateRange(int rep) { 
        DR ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (DR)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * AFF-4: "Professional Organization Affiliation Date Range" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public DR getAff4_ProfessionalOrganizationAffiliationDateRange(int rep) { 
        DR ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (DR)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Professional Organization Affiliation Date Range (AFF-4).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getAff4_ProfessionalOrganizationAffiliationDateRangeReps() {
        DR[] ret = null;
        try {
            Type[] t = this.getField(4);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * AFF-4: "Professional Organization Affiliation Date Range" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public DR insertProfessionalOrganizationAffiliationDateRange(int rep) throws HL7Exception { 
        return (DR) super.insertRepetition(4, rep);
    }



    /**
     * Inserts a repetition of
     * AFF-4: "Professional Organization Affiliation Date Range" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public DR insertAff4_ProfessionalOrganizationAffiliationDateRange(int rep) throws HL7Exception { 
        return (DR) super.insertRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * AFF-4: "Professional Organization Affiliation Date Range" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public DR removeProfessionalOrganizationAffiliationDateRange(int rep) throws HL7Exception { 
        return (DR) super.removeRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * AFF-4: "Professional Organization Affiliation Date Range" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public DR removeAff4_ProfessionalOrganizationAffiliationDateRange(int rep) throws HL7Exception { 
        return (DR) super.removeRepetition(4, rep);
    }




    /**
     * Returns
     * AFF-5: "Professional Affiliation Additional Information" - creates it if necessary
     */
    public ST getProfessionalAffiliationAdditionalInformation() { 
        ST ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * AFF-5: "Professional Affiliation Additional Information" - creates it if necessary
     */
    public ST getAff5_ProfessionalAffiliationAdditionalInformation() { 
        ST ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new XON(getMessage());
          case 2: return new XAD(getMessage());
          case 3: return new DR(getMessage());
          case 4: return new ST(getMessage());
          default: return null;
       }
   }


}

