/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v251.segment;

// import ca.uhn.hl7v2.model.v251.group.*;
import ca.uhn.hl7v2.model.v251.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 IAM message segment (Patient Adverse Reaction Information). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>IAM-1: Set ID - IAM (SI) <b> </b>
     * <li>IAM-2: Allergen Type Code (CE) <b>optional </b>
     * <li>IAM-3: Allergen Code/Mnemonic/Description (CE) <b> </b>
     * <li>IAM-4: Allergy Severity Code (CE) <b>optional </b>
     * <li>IAM-5: Allergy Reaction Code (ST) <b>optional repeating</b>
     * <li>IAM-6: Allergy Action Code (CNE) <b> </b>
     * <li>IAM-7: Allergy Unique Identifier (EI) <b>optional </b>
     * <li>IAM-8: Action Reason (ST) <b>optional </b>
     * <li>IAM-9: Sensitivity to Causative Agent Code (CE) <b>optional </b>
     * <li>IAM-10: Allergen Group Code/Mnemonic/Description (CE) <b>optional </b>
     * <li>IAM-11: Onset Date (DT) <b>optional </b>
     * <li>IAM-12: Onset Date Text (ST) <b>optional </b>
     * <li>IAM-13: Reported Date/Time (TS) <b>optional </b>
     * <li>IAM-14: Reported By (XPN) <b>optional </b>
     * <li>IAM-15: Relationship to Patient Code (CE) <b>optional </b>
     * <li>IAM-16: Alert Device Code (CE) <b>optional </b>
     * <li>IAM-17: Allergy Clinical Status Code (CE) <b>optional </b>
     * <li>IAM-18: Statused by Person (XCN) <b>optional </b>
     * <li>IAM-19: Statused by Organization (XON) <b>optional </b>
     * <li>IAM-20: Statused at Date/Time (TS) <b>optional </b>
 * </ul>
 */
public class IAM extends AbstractSegment {

    /** 
     * Creates a new IAM segment
     */
    public IAM(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, true, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Set ID - IAM");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(127) }, "Allergen Type Code");
                                  this.add(CE.class, true, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Allergen Code/Mnemonic/Description");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(128) }, "Allergy Severity Code");
                                  this.add(ST.class, false, 0, 15, new Object[]{ getMessage(), new Integer(0) }, "Allergy Reaction Code");
                                  this.add(CNE.class, true, 1, 250, new Object[]{ getMessage(), new Integer(323) }, "Allergy Action Code");
                                  this.add(EI.class, false, 1, 427, new Object[]{ getMessage(), new Integer(0) }, "Allergy Unique Identifier");
                                  this.add(ST.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Action Reason");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(436) }, "Sensitivity to Causative Agent Code");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Allergen Group Code/Mnemonic/Description");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Onset Date");
                                  this.add(ST.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Onset Date Text");
                                  this.add(TS.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Reported Date/Time");
                                  this.add(XPN.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Reported By");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(63) }, "Relationship to Patient Code");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(437) }, "Alert Device Code");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(438) }, "Allergy Clinical Status Code");
                                  this.add(XCN.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Statused by Person");
                                  this.add(XON.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Statused by Organization");
                                  this.add(TS.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Statused at Date/Time");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating IAM - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * IAM-1: "Set ID - IAM" - creates it if necessary
     */
    public SI getSetIDIAM() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IAM-1: "Set ID - IAM" - creates it if necessary
     */
    public SI getIam1_SetIDIAM() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IAM-2: "Allergen Type Code" - creates it if necessary
     */
    public CE getAllergenTypeCode() { 
        CE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IAM-2: "Allergen Type Code" - creates it if necessary
     */
    public CE getIam2_AllergenTypeCode() { 
        CE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IAM-3: "Allergen Code/Mnemonic/Description" - creates it if necessary
     */
    public CE getAllergenCodeMnemonicDescription() { 
        CE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IAM-3: "Allergen Code/Mnemonic/Description" - creates it if necessary
     */
    public CE getIam3_AllergenCodeMnemonicDescription() { 
        CE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IAM-4: "Allergy Severity Code" - creates it if necessary
     */
    public CE getAllergySeverityCode() { 
        CE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IAM-4: "Allergy Severity Code" - creates it if necessary
     */
    public CE getIam4_AllergySeverityCode() { 
        CE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Allergy Reaction Code (IAM-5).
     */
    public ST[] getAllergyReactionCode() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(5);  
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ST)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Allergy Reaction Code (IAM-5).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getAllergyReactionCodeReps() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(5);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * IAM-5: "Allergy Reaction Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getAllergyReactionCode(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IAM-5: "Allergy Reaction Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getIam5_AllergyReactionCode(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Allergy Reaction Code (IAM-5).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getIam5_AllergyReactionCodeReps() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(5);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * IAM-5: "Allergy Reaction Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertAllergyReactionCode(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(5, rep);
    }



    /**
     * Inserts a repetition of
     * IAM-5: "Allergy Reaction Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertIam5_AllergyReactionCode(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * IAM-5: "Allergy Reaction Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeAllergyReactionCode(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * IAM-5: "Allergy Reaction Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeIam5_AllergyReactionCode(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(5, rep);
    }




    /**
     * Returns
     * IAM-6: "Allergy Action Code" - creates it if necessary
     */
    public CNE getAllergyActionCode() { 
        CNE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IAM-6: "Allergy Action Code" - creates it if necessary
     */
    public CNE getIam6_AllergyActionCode() { 
        CNE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CNE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IAM-7: "Allergy Unique Identifier" - creates it if necessary
     */
    public EI getAllergyUniqueIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IAM-7: "Allergy Unique Identifier" - creates it if necessary
     */
    public EI getIam7_AllergyUniqueIdentifier() { 
        EI ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (EI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IAM-8: "Action Reason" - creates it if necessary
     */
    public ST getActionReason() { 
        ST ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IAM-8: "Action Reason" - creates it if necessary
     */
    public ST getIam8_ActionReason() { 
        ST ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IAM-9: "Sensitivity to Causative Agent Code" - creates it if necessary
     */
    public CE getSensitivityToCausativeAgentCode() { 
        CE ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IAM-9: "Sensitivity to Causative Agent Code" - creates it if necessary
     */
    public CE getIam9_SensitivityToCausativeAgentCode() { 
        CE ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IAM-10: "Allergen Group Code/Mnemonic/Description" - creates it if necessary
     */
    public CE getAllergenGroupCodeMnemonicDescription() { 
        CE ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IAM-10: "Allergen Group Code/Mnemonic/Description" - creates it if necessary
     */
    public CE getIam10_AllergenGroupCodeMnemonicDescription() { 
        CE ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IAM-11: "Onset Date" - creates it if necessary
     */
    public DT getOnsetDate() { 
        DT ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IAM-11: "Onset Date" - creates it if necessary
     */
    public DT getIam11_OnsetDate() { 
        DT ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IAM-12: "Onset Date Text" - creates it if necessary
     */
    public ST getOnsetDateText() { 
        ST ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IAM-12: "Onset Date Text" - creates it if necessary
     */
    public ST getIam12_OnsetDateText() { 
        ST ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IAM-13: "Reported Date/Time" - creates it if necessary
     */
    public TS getReportedDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IAM-13: "Reported Date/Time" - creates it if necessary
     */
    public TS getIam13_ReportedDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IAM-14: "Reported By" - creates it if necessary
     */
    public XPN getReportedBy() { 
        XPN ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IAM-14: "Reported By" - creates it if necessary
     */
    public XPN getIam14_ReportedBy() { 
        XPN ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IAM-15: "Relationship to Patient Code" - creates it if necessary
     */
    public CE getRelationshipToPatientCode() { 
        CE ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IAM-15: "Relationship to Patient Code" - creates it if necessary
     */
    public CE getIam15_RelationshipToPatientCode() { 
        CE ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IAM-16: "Alert Device Code" - creates it if necessary
     */
    public CE getAlertDeviceCode() { 
        CE ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IAM-16: "Alert Device Code" - creates it if necessary
     */
    public CE getIam16_AlertDeviceCode() { 
        CE ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IAM-17: "Allergy Clinical Status Code" - creates it if necessary
     */
    public CE getAllergyClinicalStatusCode() { 
        CE ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IAM-17: "Allergy Clinical Status Code" - creates it if necessary
     */
    public CE getIam17_AllergyClinicalStatusCode() { 
        CE ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IAM-18: "Statused by Person" - creates it if necessary
     */
    public XCN getStatusedByPerson() { 
        XCN ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IAM-18: "Statused by Person" - creates it if necessary
     */
    public XCN getIam18_StatusedByPerson() { 
        XCN ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IAM-19: "Statused by Organization" - creates it if necessary
     */
    public XON getStatusedByOrganization() { 
        XON ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IAM-19: "Statused by Organization" - creates it if necessary
     */
    public XON getIam19_StatusedByOrganization() { 
        XON ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IAM-20: "Statused at Date/Time" - creates it if necessary
     */
    public TS getStatusedAtDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IAM-20: "Statused at Date/Time" - creates it if necessary
     */
    public TS getIam20_StatusedAtDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new CE(getMessage());
          case 2: return new CE(getMessage());
          case 3: return new CE(getMessage());
          case 4: return new ST(getMessage());
          case 5: return new CNE(getMessage());
          case 6: return new EI(getMessage());
          case 7: return new ST(getMessage());
          case 8: return new CE(getMessage());
          case 9: return new CE(getMessage());
          case 10: return new DT(getMessage());
          case 11: return new ST(getMessage());
          case 12: return new TS(getMessage());
          case 13: return new XPN(getMessage());
          case 14: return new CE(getMessage());
          case 15: return new CE(getMessage());
          case 16: return new CE(getMessage());
          case 17: return new XCN(getMessage());
          case 18: return new XON(getMessage());
          case 19: return new TS(getMessage());
          default: return null;
       }
   }


}

